/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import xdat.Main;
import xdat.Session;

public class MainFileMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = true;

    public MainFileMenuActionListener(Main mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log("constructor called");
        if (e.getActionCommand().equals("Load Session")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("*.ses files", "ses");
            chooser.setFileFilter(filter);
            chooser.addChoosableFileFilter(filter);
            if (Main.getUserPreferences().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                Main.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                this.mainWindow.loadSession(filepath);
                this.mainWindow.updateDataPanel();
            }
        } else if (e.getActionCommand().equals("Save Session As...")) {
            this.saveSessionAs();
        } else if (e.getActionCommand().equals("Save Session")) {
            this.log("save session called");
            Session session = this.mainWindow.getCurrentSession();
            if (session.getSessionDirectory() == null || session.getSessionName() == null) {
                this.saveSessionAs();
            } else {
                String filepath = String.valueOf(session.getSessionDirectory()) + System.getProperty("file.separator") + session.getSessionName() + ".ses";
                this.mainWindow.saveSessionAs(filepath);
                this.mainWindow.updateDataPanel();
            }
        } else if (e.getActionCommand().equals("Exit")) {
            this.mainWindow.setVisible(false);
            this.mainWindow.dispose();
            System.exit(0);
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void saveSessionAs() {
        int returnVal;
        Session session = this.mainWindow.getCurrentSession();
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.ses files", "ses");
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        if (Main.getUserPreferences().getCurrentDir() != null) {
            chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
        }
        if ((returnVal = chooser.showSaveDialog(null)) == 0) {
            String filepath = chooser.getSelectedFile().getAbsolutePath();
            String filename = chooser.getSelectedFile().getName();
            session.setSessionDirectory(chooser.getSelectedFile().getParent());
            if (filename.endsWith(".ses")) {
                session.setSessionName(filename.substring(0, filename.length() - 4));
                this.mainWindow.saveSessionAs(filepath);
            } else {
                session.setSessionName(filename);
                this.mainWindow.saveSessionAs(String.valueOf(filepath) + ".ses");
            }
            Main.getUserPreferences().setLastFile(filepath);
            this.mainWindow.setTitle("xdat   -   " + filepath + ".ses");
            this.mainWindow.updateDataPanel();
        }
    }

    private void log(String message) {
        if (Main.isLoggingEnabled()) {
            System.out.println(String.valueOf(this.getClass().getName()) + "." + message);
        }
    }
}

