/*
 *  Copyright 2012, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package gui.menus;

import javax.swing.*;

import xdat.Main;
import actionListeners.MainChartMenuActionListener;
import java.awt.event.*;
import java.awt.*;

/**
 * Chart menu for the {@link xdat.Main} window.
 */
public class MainChartMenu 
extends JMenu
{
	/** The version tracking unique identifier for Serialization. */
	static final long serialVersionUID = 0001;
	
	/** The create menu item. */
	private JMenuItem createMenuItem = new JMenuItem("Create", 'c');
	
	/**
	 * Instantiates a new main chart menu.
	 *
	 * @param mainWindow the main window
	 */
	public MainChartMenu(Main mainWindow)
	{
		super("Chart");
		this.setMnemonic(KeyEvent.VK_C);
		MainChartMenuActionListener cmd = new MainChartMenuActionListener(mainWindow);
		//Chart
		
//		setCtrlAccelerator(mi, 'C');
		createMenuItem.setMnemonic(KeyEvent.VK_C);
		createMenuItem.addActionListener(cmd);
		createMenuItem.setEnabled(false);
		this.add(createMenuItem);
		

		this.setItemsRequiringDataSheetEnabled(false);
	}

	/**
	 * Specifies whether the menu item createMenuItem is enabled.
	 * This is required because this item is only available when data
	 * is loaded.
	 * 
	 * @param enabled specifies whether the menu item createMenuItem is 
	 * enabled.
	 */
	public void setItemsRequiringDataSheetEnabled(boolean enabled)
	{
		this.createMenuItem.setEnabled(enabled);
	}
	
	/**
	 * Sets the ctrl accelerator.
	 *
	 * @param mi the menu item
	 * @param acc the accelerator
	 */	
	private void setCtrlAccelerator(JMenuItem mi, char acc)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(acc, Event.CTRL_MASK);
		mi.setAccelerator(ks);
	}
	
}
