/*
 *  Copyright 2012, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package actionListeners;

import gui.dialogs.DisplaySettingsDialog;
import gui.dialogs.FileImportSettingsDialog;
import gui.frames.ChartFrame;
import gui.menus.ChartFrameOptionsMenu;

import java.awt.event.*;

import xdat.*;

import chart.Chart;

/**
 * ActionListener that is used for a {@link ChartFrameOptionsMenu}.
 */
public class ChartFrameOptionsMenuActionListener 
implements ActionListener
{
	
	/** The main window. */
	private Main mainWindow;
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/** The chart. */
	private Chart chart;
	
	/** The chart frame. */
	private ChartFrame chartFrame;
	
	/**
	 * Instantiates a new chart frame options menu action listener.
	 *
	 * @param mainWindow the main window
	 * @param chart the chart
	 * @param chartFrame the chart frame
	 */
	public ChartFrameOptionsMenuActionListener(Main mainWindow, Chart chart, ChartFrame chartFrame)
	{
		this.mainWindow = mainWindow;
		this.chart = chart;
		this.chartFrame = chartFrame;
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		log("constructor called");
		if(e.getActionCommand().equals("Import Settings"))
		{
			new FileImportSettingsDialog(this.mainWindow);
		}
		else if(e.getActionCommand().equals("Display Settings"))
		{
			new DisplaySettingsDialog(this.mainWindow, this.chart, this.chartFrame);
		}

		else if(e.getActionCommand().equals("Reset to Default"))
		{
			this.chart.resetDisplaySettingsToDefault();
			this.chartFrame.repaint();
		}

		else
		{
			System.out.println(e.getActionCommand());
		}
	}

	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(ChartFrameOptionsMenuActionListener.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}
}
