/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import data.DataSheet;
import gui.tables.DataSheetTableColumnModel;
import gui.tables.DataTable;
import java.awt.GridLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import xdat.Main;

public class DataSheetTablePanel
extends JPanel {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;
    private DataTable dataTable;

    public DataSheetTablePanel(Main mainWindow, DataSheet dataSheet) {
        this.mainWindow = mainWindow;
        this.log("constructor called");
        this.setLayout(new GridLayout(1, 1));
        this.updateRunsTableModel(dataSheet);
    }

    private void updateRunsTableModel(DataSheet dataSheet) {
        this.removeAll();
        DataSheetTableColumnModel cm = new DataSheetTableColumnModel(this.mainWindow, dataSheet);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setHorizontalAlignment(0);
        TableColumn idCol = new TableColumn(0, 30, cellRenderer, new DefaultCellEditor(new JTextField()));
        idCol.setHeaderValue("#");
        idCol.setResizable(true);
        cm.addColumn(idCol);
        TableColumn[] cols = new TableColumn[dataSheet.getParameterCount() + 1];
        int colIndex = 1;
        while (colIndex <= dataSheet.getParameterCount()) {
            cols[colIndex] = new TableColumn(colIndex, 100, cellRenderer, new DefaultCellEditor(new JTextField()));
            cols[colIndex].setHeaderValue(dataSheet.getParameterName(colIndex - 1));
            cols[colIndex].setResizable(true);
            cm.addColumn(cols[colIndex]);
            ++colIndex;
        }
        this.dataTable = new DataTable(dataSheet, (TableColumnModel)cm, this.mainWindow);
        this.dataTable.setAutoResizeMode(0);
        this.dataTable.setShowGrid(true);
        this.dataTable.setColumnSelectionAllowed(false);
        this.dataTable.setRowSelectionAllowed(true);
        JScrollPane scrollPane = new JScrollPane(this.dataTable);
        this.setLayout(new GridLayout(1, 1));
        this.add(scrollPane);
    }

    private void log(String message) {
    }

    public JTable getDataTable() {
        return this.dataTable;
    }
}

