/*
 * Decompiled with CFR 0.152.
 */
package gui.menus;

import actionListeners.ChartFrameAddDesignToClusterMenuActionListener;
import data.ClusterSet;
import gui.frames.ChartFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import xdat.Main;

public class ChartFrameAddDesignToClusterMenu
extends JMenu {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    private Main mainWindow;
    private ChartFrame chartFrame;

    public ChartFrameAddDesignToClusterMenu(Main mainWindow, ChartFrame chartFrame) {
        super("Add filtered designs to cluster");
        this.log("constructor called.");
        this.mainWindow = mainWindow;
        this.chartFrame = chartFrame;
        this.setMnemonic(65);
        ChartFrameAddDesignToClusterMenuActionListener cmd = new ChartFrameAddDesignToClusterMenuActionListener(mainWindow, chartFrame);
        ClusterSet clusterSet = mainWindow.getDataSheet().getClusterSet();
        if (clusterSet.getClusterCount() == 0) {
            JMenuItem mi = new JMenuItem("No clusters defined");
            this.add(mi);
            mi.setEnabled(false);
        } else {
            int i = 0;
            while (i < clusterSet.getClusterCount()) {
                JMenuItem mi = new JMenuItem(clusterSet.getCluster(i).getName());
                mi.addActionListener(cmd);
                this.add(mi);
                ++i;
            }
        }
    }

    public void updateClusterList() {
        this.removeAll();
        ChartFrameAddDesignToClusterMenuActionListener cmd = new ChartFrameAddDesignToClusterMenuActionListener(this.mainWindow, this.chartFrame);
        ClusterSet clusterSet = this.mainWindow.getDataSheet().getClusterSet();
        if (clusterSet.getClusterCount() == 0) {
            JMenuItem mi = new JMenuItem("No clusters defined");
            this.add(mi);
            mi.setEnabled(false);
        } else {
            int i = 0;
            while (i < clusterSet.getClusterCount()) {
                JMenuItem mi = new JMenuItem(clusterSet.getCluster(i).getName());
                mi.addActionListener(cmd);
                this.add(mi);
                ++i;
            }
        }
    }

    private void setCtrlAccelerator(JMenuItem mi, char acc) {
        KeyStroke ks = KeyStroke.getKeyStroke((int)acc, 2);
        mi.setAccelerator(ks);
    }

    private void log(String message) {
    }
}

