/*
 * Decompiled with CFR 0.152.
 */
package workerThreads;

import data.DataSheet;
import exceptions.InconsistentDataException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import xdat.Main;

public class DataSheetUpdateThread
extends SwingWorker {
    static final boolean printLog = false;
    private String pathToInputFile;
    private boolean dataHasHeaders;
    private Main mainWindow;
    private ProgressMonitor progressMonitor;

    public DataSheetUpdateThread(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) {
        this.log("constructor called");
        this.pathToInputFile = pathToInputFile;
        this.dataHasHeaders = dataHasHeaders;
        this.mainWindow = mainWindow;
        this.progressMonitor = progressMonitor;
    }

    public Object doInBackground() {
        try {
            DataSheet dataSheet = this.mainWindow.getDataSheet();
            dataSheet.updateData(this.pathToInputFile, this.dataHasHeaders, this.progressMonitor);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.mainWindow, "Error on updating data from file:\n " + e.getMessage(), "Update Data", 0);
        }
        catch (InconsistentDataException e1) {
            JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(e1.getMessage()) + "\nThe previous state will be restored.", "Update Data", 0);
        }
        this.progressMonitor.close();
        return null;
    }

    private void log(String message) {
    }
}

