/*
 * Decompiled with CFR 0.152.
 */
package data;

import chart.Chart;
import customEvents.DataTableModelEvent;
import data.ClusterSet;
import data.Design;
import data.NumberParser;
import data.Parameter;
import exceptions.InconsistentDataException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xdat.Main;
import xdat.UserPreferences;

public class DataSheet
implements TableModel,
Serializable {
    static final long serialVersionUID = 8L;
    static final boolean printLog = false;
    private ClusterSet clusterSet;
    private Vector<Design> data = new Vector(0, 1);
    private Vector<Parameter> parameters = new Vector(0, 1);
    private transient Vector<TableModelListener> listeners = new Vector();
    private String delimiter;

    public DataSheet(String pathToInputFile, boolean dataHasHeaders, Main mainWindow, ProgressMonitor progressMonitor) throws IOException {
        UserPreferences userPreferences = Main.getUserPreferences();
        this.clusterSet = new ClusterSet(this);
        this.delimiter = userPreferences.getDelimiter();
        if (userPreferences.isTreatConsecutiveAsOne()) {
            this.delimiter = String.valueOf(this.delimiter) + "+";
        }
        this.importData(pathToInputFile, dataHasHeaders, progressMonitor);
        boolean continueChecking = true;
        int i = 0;
        while (i < this.parameters.size()) {
            if (this.parameters.get(i).isMixed() && continueChecking) {
                int userAction = JOptionPane.showConfirmDialog(mainWindow, "Parameter " + this.parameters.get(i).getName() + " has numeric values in some designs\n" + "and non-numerical values in others. \nThis will result in the parameter being treated as a \n" + "non-numeric parameter. \n" + "If this is incorrect it is recommended to find the design(s)\n" + "with non-numeric values and correct or remove them.\n\n" + "Press Ok to continue checking parameters or Cancel to\n" + "suppress further warnings.", "Mixed Parameter Warning", 2, 2);
                continueChecking = userAction == 0;
            }
            ++i;
        }
    }

    private void importData(String pathToInputFile, boolean dataHasHeaders, ProgressMonitor progressMonitor) throws IOException {
        Vector buffer = new Vector(0, 1);
        if (this.data != null) {
            buffer = (Vector)this.data.clone();
        }
        int lineCount = this.getLineCount(pathToInputFile);
        progressMonitor.setMaximum(lineCount);
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (dataHasHeaders) {
            int i = 0;
            while (i < lineElements.length) {
                this.parameters.add(new Parameter(this.getUniqueParameterName(lineElements[i]), this));
                ++i;
            }
        } else {
            Design newDesign = new Design(idCounter++);
            int i = 0;
            while (i < lineElements.length) {
                this.parameters.add(new Parameter("Parameter " + (i + 1), this));
                newDesign.setValue(this.parameters.get(i), lineElements[i]);
                ++i;
            }
            this.data.add(newDesign);
            progressMonitor.setProgress(idCounter - 1);
        }
        try {
            this.readDesignsFromFile(progressMonitor, f, idCounter);
        }
        catch (IOException e) {
            this.data = buffer;
            throw e;
        }
        f.close();
        if (progressMonitor.isCanceled()) {
            this.data = buffer;
        }
    }

    public void updateData(String pathToInputFile, boolean dataHasHeaders, ProgressMonitor progressMonitor) throws IOException, InconsistentDataException {
        int lineCount = this.getLineCount(pathToInputFile);
        progressMonitor.setMaximum(lineCount);
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (lineElements.length != this.getParameterCount()) {
            throw new InconsistentDataException(pathToInputFile);
        }
        Vector buffer = (Vector)this.data.clone();
        this.data.removeAllElements();
        this.log("updateData: bufferlength: " + buffer.size());
        int i = 0;
        while (i < this.parameters.size()) {
            this.parameters.get(i).resetDiscreteLevelsAndState();
            ++i;
        }
        if (dataHasHeaders) {
            i = 0;
            while (i < this.parameters.size()) {
                this.parameters.get(i).setName(null);
                ++i;
            }
            i = 0;
            while (i < lineElements.length) {
                this.parameters.get(i).setName(this.getUniqueParameterName(lineElements[i]));
                ++i;
            }
        } else {
            Design newDesign = new Design(idCounter++);
            int i2 = 0;
            while (i2 < this.parameters.size()) {
                if (lineElements.length <= i2) {
                    newDesign.setValue(this.parameters.get(i2), "-");
                } else {
                    this.parameters.get(i2).setName("Parameter " + (i2 + 1));
                    newDesign.setValue(this.parameters.get(i2), lineElements[i2]);
                }
                ++i2;
            }
            this.data.add(newDesign);
        }
        try {
            this.readDesignsFromFile(progressMonitor, f, idCounter);
        }
        catch (IOException e) {
            this.data = buffer;
            throw e;
        }
        f.close();
        this.log("update data pm canceled state: " + progressMonitor.isCanceled());
        if (progressMonitor.isCanceled()) {
            this.data = buffer;
        }
        this.fireTableChanged(0, this.data.size(), -1, false, true, true, this.initialiseBooleanArray(true), this.initialiseBooleanArray(true), this.initialiseBooleanArray(true));
    }

    private void readDesignsFromFile(ProgressMonitor progressMonitor, BufferedReader f, int idCounter) throws IOException {
        String line;
        while ((line = f.readLine()) != null && !progressMonitor.isCanceled()) {
            progressMonitor.setProgress(idCounter - 1);
            String[] lineElements = line.split(this.delimiter);
            if (lineElements.length < 1) continue;
            Design newDesign = new Design(idCounter++);
            boolean newDesignContainsValues = false;
            int i = 0;
            while (i < lineElements.length) {
                if (lineElements[i].length() > 0 && !lineElements[i].equals(new String("\\s"))) {
                    newDesignContainsValues = true;
                }
                ++i;
            }
            if (!newDesignContainsValues) continue;
            i = 0;
            while (i < this.parameters.size()) {
                if (lineElements.length <= i || lineElements[i].length() <= 0 || lineElements[i].equals(new String("\\s"))) {
                    newDesign.setValue(this.parameters.get(i), "-");
                } else {
                    newDesignContainsValues = true;
                    newDesign.setValue(this.parameters.get(i), lineElements[i]);
                }
                ++i;
            }
            this.data.add(newDesign);
        }
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.parameters.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.parameters.get(columnIndex).getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.data.get(rowIndex).getId();
        }
        return this.data.get(rowIndex).getStringValue(this.parameters.get(columnIndex - 1));
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        boolean previousNumeric = this.parameters.get(columnIndex - 1).isNumeric();
        String previousValue = this.getValueAt(rowIndex, columnIndex).toString();
        boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
        boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
        boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(false);
        try {
            this.data.get(rowIndex).setValue(this.parameters.get(columnIndex - 1), arg0.toString());
            if (!previousNumeric) {
                this.parameters.get(columnIndex - 1).checkOccurrenceInDiscreteLevel(previousValue);
            }
            NumberParser.parseNumber(arg0.toString());
            if (!previousNumeric) {
                this.parameters.get(columnIndex - 1).checkIfNumeric();
                axisAutofitRequired[columnIndex - 1] = true;
                axisResetFilterRequired[columnIndex - 1] = true;
            }
        }
        catch (ParseException e1) {
            this.log("setValueAt: value " + arg0.toString() + " of parameter " + this.parameters.get(columnIndex - 1).getName() + " is not numeric.");
            this.parameters.get(columnIndex - 1).setNumeric(false);
        }
        axisApplyFiltersRequired[columnIndex - 1] = true;
        this.fireTableChanged(rowIndex, rowIndex, columnIndex - 1, false, true, false, axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTableChanged(int firstRow, int lastRow, int column, boolean chartRebuildRequired, boolean chartRepaintRequired, boolean dataPanelUpdateRequired, boolean[] axisAutofitRequired, boolean[] axisResetFilterRequired, boolean[] axisApplyFiltersRequired) {
        DataTableModelEvent e = new DataTableModelEvent(this, firstRow, lastRow, column, chartRebuildRequired, chartRepaintRequired, dataPanelUpdateRequired, axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired);
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            this.listeners.get(i).tableChanged(e);
            ++i;
        }
    }

    private int getLineCount(String pathToInputFile) throws FileNotFoundException, IOException {
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        int lineCount = 0;
        while (f.readLine() != null) {
            ++lineCount;
        }
        f.close();
        return lineCount;
    }

    public Design getDesign(int i) {
        return this.data.get(i);
    }

    public void addDesign(Design design) {
        this.data.add(design);
        boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
        boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
        boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(true);
        this.fireTableChanged(this.getDesignCount() - 1, this.getDesignCount() - 1, -1, false, true, false, axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired);
    }

    public void removeDesigns(int[] designsToRemove) {
        boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
        boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
        boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(false);
        boolean[] discrete = new boolean[this.parameters.size()];
        int i = 0;
        while (i < this.parameters.size()) {
            discrete[i] = !this.parameters.get(i).isNumeric();
            ++i;
        }
        i = designsToRemove.length - 1;
        while (i >= 0) {
            Design removedDesign = this.data.remove(designsToRemove[i]);
            int j = 0;
            while (j < this.parameters.size()) {
                if (!this.parameters.get(j).isNumeric()) {
                    try {
                        String string = removedDesign.getStringValue(this.parameters.get(j));
                        NumberParser.parseNumber(string);
                    }
                    catch (ParseException e1) {
                        this.parameters.get(j).checkOccurrenceInDiscreteLevel(removedDesign.getStringValue(this.parameters.get(j)));
                        this.parameters.get(j).checkIfNumeric();
                    }
                }
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < this.parameters.size()) {
            axisAutofitRequired[i] = discrete[i] && this.parameters.get(i).isNumeric();
            axisApplyFiltersRequired[i] = discrete[i];
            ++i;
        }
        this.fireTableChanged(designsToRemove[0], designsToRemove[designsToRemove.length - 1], -1, false, true, true, axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired);
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameterName(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index).getName();
    }

    public Parameter getParameter(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index);
    }

    public Parameter getParameter(String parameterName) {
        int i = 0;
        while (i < this.parameters.size()) {
            if (parameterName.equals(this.parameters.get(i).getName())) {
                return this.parameters.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " not found");
    }

    public Parameter removeParameter(String parameterName) {
        int i = 0;
        while (i < this.parameters.size()) {
            if (parameterName.equals(this.parameters.get(i).getName())) {
                Parameter removedParam = this.parameters.remove(i);
                int j = 0;
                while (j < this.data.size()) {
                    Design design = this.data.get(j);
                    design.removeParameter(removedParam);
                    ++j;
                }
                boolean[] axisAutofitRequired = this.initialiseBooleanArray(false);
                boolean[] axisResetFilterRequired = this.initialiseBooleanArray(false);
                boolean[] axisApplyFiltersRequired = this.initialiseBooleanArray(false);
                this.fireTableChanged(0, this.data.size() - 1, i, false, true, true, axisAutofitRequired, axisResetFilterRequired, axisApplyFiltersRequired);
                return removedParam;
            }
            ++i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " not found");
    }

    public double getMaxValueOf(Parameter param) {
        if (param.isNumeric()) {
            double max = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                this.log("getMaxValueOf: max = " + max);
                if (max < this.data.get(i).getDoubleValue(param)) {
                    this.log("getMaxValueOf: Higher value found. New max = " + max);
                    max = this.data.get(i).getDoubleValue(param);
                }
                ++i;
            }
            this.log("getMaxValueOf: Final max = " + max);
            return max;
        }
        return param.getDiscreteLevelCount() - 1;
    }

    public double getMinValueOf(Parameter param) {
        if (param.isNumeric()) {
            double min = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                if (min > this.data.get(i).getDoubleValue(param)) {
                    min = this.data.get(i).getDoubleValue(param);
                }
                ++i;
            }
            return min;
        }
        return 0.0;
    }

    public int getDesignCount() {
        return this.data.size();
    }

    private String getUniqueParameterName(String nameSuggestion) {
        String name = nameSuggestion;
        int id = 2;
        while (!this.isNameUnique(name)) {
            name = String.valueOf(nameSuggestion) + " (" + id++ + ")";
        }
        return name;
    }

    private boolean isNameUnique(String name) {
        boolean unique = true;
        int i = 0;
        while (i < this.parameters.size()) {
            if (name.equals(this.parameters.get(i).getName())) {
                unique = false;
                break;
            }
            ++i;
        }
        return unique;
    }

    private void log(String message) {
    }

    public ClusterSet getClusterSet() {
        return this.clusterSet;
    }

    public void setClusterSet(ClusterSet clusterSet) {
        this.clusterSet = clusterSet;
    }

    public void evaluateBoundsForAllDesigns(Chart chart) {
        int i = 0;
        while (i < this.getDesignCount()) {
            this.data.get(i).evaluateBounds(chart);
            ++i;
        }
    }

    public void moveParameter(int oldIndex, int newIndex) {
        this.log("moveParameter called with arguments " + oldIndex + " and " + newIndex);
        Parameter param = this.parameters.remove(oldIndex);
        this.parameters.insertElementAt(param, newIndex);
        this.log("new order is:");
        int i = 0;
        while (i < this.parameters.size()) {
            this.log(String.valueOf(i) + " :  " + this.parameters.get(i).getName());
            ++i;
        }
    }

    private boolean[] initialiseBooleanArray(boolean value) {
        boolean[] array = new boolean[this.getParameterCount()];
        int i = 0;
        while (i < this.getParameterCount()) {
            array[i] = value;
            ++i;
        }
        return array;
    }
}

