/*
 * Decompiled with CFR 0.152.
 */
package data;

import data.Cluster;
import data.DataSheet;
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ClusterSet
implements Serializable,
TableModel {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private DataSheet dataSheet;
    private Vector<Cluster> clusters = new Vector(0, 1);
    private Vector<Cluster> clustersBuffer = new Vector(0, 1);
    private transient Vector<TableModelListener> listeners = new Vector();
    private int uniqueIdentificationNumberCounter = 0;

    public ClusterSet(DataSheet dataSheet) {
        this.dataSheet = dataSheet;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Cluster";
            }
            case 1: {
                return "Color";
            }
            case 2: {
                return "Active";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.clustersBuffer.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.clustersBuffer.get(rowIndex).getName();
            }
            case 1: {
                return this.clustersBuffer.get(rowIndex).getActiveDesignColor();
            }
            case 2: {
                return this.clustersBuffer.get(rowIndex).isActive();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        this.log("setValueAt: argument is " + arg0.toString());
        switch (columnIndex) {
            case 0: {
                if (this.isNameUnique(arg0.toString(), rowIndex)) {
                    this.clustersBuffer.get(rowIndex).setName(arg0.toString());
                    break;
                }
                JOptionPane.showMessageDialog(null, "This name is not unique. Please choose a different name.", "Rename Cluster", 1);
                break;
            }
            case 1: {
                this.clustersBuffer.get(rowIndex).setActiveDesignColor((Color)arg0);
                break;
            }
            case 2: {
                this.log("setValueAt: setting active of cluster " + this.clustersBuffer.get(rowIndex).getName() + " to " + arg0.toString());
                this.clustersBuffer.get(rowIndex).setActive(Boolean.parseBoolean(arg0.toString()));
                this.log("setValueAt: active of cluster " + this.clustersBuffer.get(rowIndex).getName() + " is now " + this.clustersBuffer.get(rowIndex).isActive());
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTableChanged() {
        TableModelEvent e = new TableModelEvent(this);
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            this.listeners.get(i).tableChanged(e);
            ++i;
        }
    }

    public void addClusterToBuffer() {
        this.log("addClusterToBuffer called");
        String newClusterName = this.getUniqueClusterName();
        Cluster newCluster = new Cluster(newClusterName, this.uniqueIdentificationNumberCounter++);
        this.clustersBuffer.add(newCluster);
        this.fireTableChanged();
    }

    public void removeClusterFromBuffer(int i) {
        this.clustersBuffer.remove(i);
        this.fireTableChanged();
    }

    public void removeClusterFromBuffer(Cluster cluster) {
        this.clustersBuffer.remove(cluster);
        this.fireTableChanged();
    }

    public Cluster getCluster(int i) {
        return this.clusters.get(i);
    }

    public Cluster getCluster(String clusterName) {
        int i = 0;
        while (i < this.clusters.size()) {
            if (this.clusters.get(i).getName().equals(clusterName)) {
                return this.clusters.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Could not find cluster " + clusterName);
    }

    public int getClusterCount() {
        return this.clusters.size();
    }

    public void removeClusterFromBuffer(String clusterName) {
        int i = 0;
        while (i < this.clustersBuffer.size()) {
            if (this.clustersBuffer.get(i).getName().equals(clusterName)) {
                this.clustersBuffer.remove(i);
                this.fireTableChanged();
            }
            ++i;
        }
        throw new IllegalArgumentException("Could not find cluster " + clusterName);
    }

    private String getUniqueClusterName() {
        String name = "Cluster 1";
        int id = 1;
        while (!this.isNameUnique(name)) {
            name = "Cluster " + id++;
        }
        return name;
    }

    private boolean isNameUnique(String name) {
        boolean unique = true;
        int i = 0;
        while (i < this.clustersBuffer.size()) {
            if (name.equals(this.clustersBuffer.get(i).getName())) {
                unique = false;
                break;
            }
            ++i;
        }
        return unique;
    }

    private boolean isNameUnique(String name, int exception) {
        boolean unique = true;
        int i = 0;
        while (i < this.clustersBuffer.size()) {
            if (name.equals(this.clustersBuffer.get(i).getName()) && i != exception) {
                unique = false;
                break;
            }
            ++i;
        }
        return unique;
    }

    public void applyChanges() {
        this.log("applyChanges invoked");
        int i = this.clusters.size() - 1;
        while (i >= 0) {
            boolean clusterRemoved = true;
            int j = this.clustersBuffer.size() - 1;
            while (j >= 0) {
                if (this.clusters.get(i).getUniqueIdentificationNumber() == this.clustersBuffer.get(j).getUniqueIdentificationNumber()) {
                    clusterRemoved = false;
                    this.clustersBuffer.remove(j).copySettingsTo(this.clusters.get(i));
                    break;
                }
                --j;
            }
            if (clusterRemoved) {
                Cluster c = this.clusters.remove(i);
                int j2 = 0;
                while (j2 < this.dataSheet.getDesignCount()) {
                    if (c.equals(this.dataSheet.getDesign(j2).getCluster())) {
                        this.dataSheet.getDesign(j2).setCluster(null);
                    }
                    ++j2;
                }
            }
            --i;
        }
        i = 0;
        while (i < this.clustersBuffer.size()) {
            this.clusters.add(this.clustersBuffer.get(i).duplicate());
            ++i;
        }
    }

    public void createBuffer() {
        this.log("createBuffer invoked");
        this.clustersBuffer.removeAllElements();
        int i = 0;
        while (i < this.clusters.size()) {
            this.clustersBuffer.add(this.clusters.get(i).duplicate());
            ++i;
        }
    }

    private void log(String message) {
    }
}

