/*
 *  Copyright 2010, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */


package gui.menus;

import gui.frames.ChartFrame;
import javax.swing.*;

import xdat.Main;
import actionListeners.ChartFrameOptionsMenuActionListener;
import java.awt.event.*;
import java.awt.*;

/**
 * Options Menu for a {@link gui.frames.ChartFrame} 
 */
public class ChartFrameOptionsMenu 
extends JMenu
{
	
	/** The version tracking unique identifier for Serialization. */
	static final long serialVersionUID = 0001;
	
	/** The action listener. */
	private ChartFrameOptionsMenuActionListener cmd;
	
	/**
	 * Instantiates a new chart frame options menu.
	 *
	 * @param mainWindow the main window
	 * @param chartFrame the chart frame
	 */
	public ChartFrameOptionsMenu(Main mainWindow, ChartFrame chartFrame)
	{
		super("Options");
		this.setMnemonic(KeyEvent.VK_O);
		JMenuItem mi;
		cmd = new ChartFrameOptionsMenuActionListener(mainWindow, chartFrame.getChart(), chartFrame);
		// 
		mi = new JMenuItem("Display Settings", 'd');
		mi.setMnemonic(KeyEvent.VK_D);
		mi.addActionListener(cmd);
		this.add(mi);
	    //
		mi = new JMenuItem("Reset to Default", 'r');
		mi.setMnemonic(KeyEvent.VK_R);
		mi.addActionListener(cmd);
		this.add(mi);
	}

	/**
	 * Sets the ctrl accelerator.
	 *
	 * @param mi the menu item
	 * @param acc the accelerator
	 */
	private void setCtrlAccelerator(JMenuItem mi, char acc)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(acc, Event.CTRL_MASK);
		mi.setAccelerator(ks);
	}
	
}
