/*
 *  Copyright 2010, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package gui.menus;
import gui.frames.ChartFrame;
import javax.swing.*;

import xdat.Main;
import actionListeners.ChartFrameClusteringMenuActionListener;
import java.awt.event.*;
import java.awt.*;

/**
 * Menu for a {@link gui.frames.ChartFrame} to edit {@link data.Cluster}s.
 */
public class ChartFrameClusteringMenu 
extends JMenu
{
	
	/** The version tracking unique identifier for Serialization. */
	static final long serialVersionUID = 0001;
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/**
	 * Instantiates a new chart frame clustering menu.
	 *
	 * @param mainWindow the main window
	 * @param chartFrame the chart frame
	 */
	public ChartFrameClusteringMenu(Main mainWindow, ChartFrame chartFrame)
	{
		super("Clustering");
		log("constructor called.");
		this.setMnemonic(KeyEvent.VK_C);
		
		
		// Edit clusters
		ChartFrameClusteringMenuActionListener cmd = new ChartFrameClusteringMenuActionListener(mainWindow, chartFrame);

		JMenuItem mi;
		mi = new JMenuItem("Edit Clusters");
		mi.addActionListener(cmd);
		this.add(mi);
		
		// Add to Cluster
		ChartFrameAddDesignToClusterMenu clustersMenu;
		clustersMenu = new ChartFrameAddDesignToClusterMenu(mainWindow, chartFrame);
		chartFrame.setClusterMenu(clustersMenu);
		this.add(clustersMenu);

		
	}

	/**
	 * Sets the ctrl accelerator.
	 *
	 * @param mi the menuitem
	 * @param acc the accelerator
	 */
	private void setCtrlAccelerator(JMenuItem mi, char acc)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(acc, Event.CTRL_MASK);
		mi.setAccelerator(ks);
	}
	
	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(ChartFrameClusteringMenu.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}		
}
