/*
 *  Copyright 2010, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package actionListeners;

import gui.dialogs.ClusterDialog;
import gui.menus.MainDataMenu;

import java.awt.event.*;
import java.io.File;
import java.io.IOException;


import javax.swing.*;

import xdat.*;

import data.DataSheet;
import exceptions.InconsistentDataException;

/**
 * ActionListener for a {@link MainDataMenu}.
 */
public class MainDataMenuActionListener 
implements ActionListener
{
	
	/** The main window. */
	private Main mainWindow;
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/**
	 * Instantiates a new main data menu action listener.
	 *
	 * @param mainWindow the main window
	 */
	public MainDataMenuActionListener(Main mainWindow)
	{
		log("constructor called.");
		this.mainWindow = mainWindow;
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{

		if(e.getActionCommand().equals("Import Data with Headers"))
		{
			if(		mainWindow.getChartFrameCount() == 0 || 
					JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", JOptionPane.OK_CANCEL_OPTION)
			)
			{
				mainWindow.disposeAllChartFrames();
				String filepath;
				JFileChooser chooser = new JFileChooser();
				if(mainWindow.getUserPreferences().getCurrentDir()!=null)
					chooser.setCurrentDirectory(new File(mainWindow.getUserPreferences().getCurrentDir()));
				int returnVal = chooser.showOpenDialog(null);
	
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					filepath = chooser.getSelectedFile().getAbsolutePath();
					mainWindow.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
					try {
						this.mainWindow.setDataSheet(new DataSheet(filepath, true));
					} catch (IOException e1) {
						JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n "+e1.getMessage(), "Import Data", JOptionPane.ERROR_MESSAGE);
					} 
					this.mainWindow.updateDataPanel();
					this.mainWindow.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
				}
			}
 
		}
		else if(e.getActionCommand().equals("Import Data without Headers"))
		{
			if(		mainWindow.getChartFrameCount() == 0 || 
					JOptionPane.OK_OPTION == JOptionPane.showConfirmDialog(mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", JOptionPane.OK_CANCEL_OPTION)
			)
			{
				mainWindow.disposeAllChartFrames();
				String filepath;
				JFileChooser chooser = new JFileChooser();
				if(mainWindow.getUserPreferences().getCurrentDir()!=null)
					chooser.setCurrentDirectory(new File(mainWindow.getUserPreferences().getCurrentDir()));
				int returnVal = chooser.showOpenDialog(null);
	
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					filepath = chooser.getSelectedFile().getAbsolutePath();
					mainWindow.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
					try {
						this.mainWindow.setDataSheet(new DataSheet(filepath, false));
					} catch (IOException e1) {
						JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n "+e1.getMessage(), "Import Data", JOptionPane.ERROR_MESSAGE);
					}
					this.mainWindow.updateDataPanel();
				}
			}
		}
		
		else if(e.getActionCommand().equals("Update Data from File with Headers"))
		{
			String filepath;
			JFileChooser chooser = new JFileChooser();
			if(mainWindow.getUserPreferences().getCurrentDir()!=null)
				chooser.setCurrentDirectory(new File(mainWindow.getUserPreferences().getCurrentDir()));
			int returnVal = chooser.showOpenDialog(null);

			if (returnVal == JFileChooser.APPROVE_OPTION) {
				filepath = chooser.getSelectedFile().getAbsolutePath();
				mainWindow.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
				try {
					this.mainWindow.getDataSheet().updateData(filepath, true);
				} catch (IOException e1) {
					JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n "+e1.getMessage(), "Import Data", JOptionPane.ERROR_MESSAGE);
				} catch (InconsistentDataException e1) {
					JOptionPane.showMessageDialog(this.mainWindow, e1.getMessage()+"\nThe previous state will be restored.", "Update Data", JOptionPane.ERROR_MESSAGE);
				}
				this.mainWindow.updateDataPanel();
				this.mainWindow.updateAllChartFrames();
			}
 
		}
		else if(e.getActionCommand().equals("Update Data from File without Headers"))
		{
			String filepath;
			JFileChooser chooser = new JFileChooser();
			if(mainWindow.getUserPreferences().getCurrentDir()!=null)
				chooser.setCurrentDirectory(new File(mainWindow.getUserPreferences().getCurrentDir()));
			int returnVal = chooser.showOpenDialog(null);

			if (returnVal == JFileChooser.APPROVE_OPTION) {
				filepath = chooser.getSelectedFile().getAbsolutePath();
				mainWindow.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
				try {
					this.mainWindow.getDataSheet().updateData(filepath, false);
				} catch (IOException e1) {
					JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n "+e1.getMessage(), "Import Data", JOptionPane.ERROR_MESSAGE);
				} catch (InconsistentDataException e1) {
					JOptionPane.showMessageDialog(this.mainWindow, e1.getMessage()+"\nThe previous state will be restored.", "Update Data", JOptionPane.ERROR_MESSAGE);
				}
				this.mainWindow.updateDataPanel();
				this.mainWindow.updateAllChartFrames();
			}
		}		
		else if(e.getActionCommand().equals("Clustering"))
		{
			if(mainWindow.getDataSheet() == null)
				JOptionPane.showMessageDialog(mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", JOptionPane.INFORMATION_MESSAGE);
			else
				new ClusterDialog(this.mainWindow, this.mainWindow, mainWindow.getDataSheet());
 
		}
		else
		{
			System.out.println(e.getActionCommand());
		}
	}

		


	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(MainDataMenuActionListener.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}
}
