/*
 * Decompiled with CFR 0.152.
 */
package xdat;

import java.awt.Color;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    static final long serialVersionUID = 3L;
    static final boolean printLog = false;
    private Preferences prefs;
    private String versionString;
    public static final int IMPORT_FROM_HOMEDIR = 0;
    public static final int IMPORT_FROM_LASTDIR = 1;
    public static final int IMPORT_FROM_USERDIR = 2;
    private String lastFile = System.getProperty("user.home");
    private String userDir = System.getProperty("user.home");

    public UserPreferences(String versionString) {
        this.log("constructor called.");
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.versionString = versionString;
    }

    public boolean isLicenseAccepted() {
        return this.prefs.getBoolean("version" + this.versionString + "licenseAcceptedBy" + System.getProperty("user.name"), false);
    }

    public void setLicenseAccepted(boolean licenseAccepted) {
        this.prefs.putBoolean("version" + this.versionString + "licenseAcceptedBy" + System.getProperty("user.name"), licenseAccepted);
    }

    public Color getAxisColor() {
        int r = this.prefs.getInt("axisColorRed", 0);
        int g = this.prefs.getInt("axisColorGreen", 0);
        int b = this.prefs.getInt("axisColorBlue", 0);
        return new Color(r, g, b);
    }

    public void setAxisColor(Color axisColor) {
        this.prefs.putInt("axisColorRed", axisColor.getRed());
        this.prefs.putInt("axisColorGreen", axisColor.getGreen());
        this.prefs.putInt("axisColorBlue", axisColor.getBlue());
    }

    public int getAxisHeight() {
        return this.prefs.getInt("axisHeight", 400);
    }

    public void setAxisHeight(int axisHeight) {
        this.prefs.putInt("axisHeight", axisHeight);
    }

    public Color getAxisLabelFontColor() {
        int r = this.prefs.getInt("axisLabelFontColorRed", 0);
        int g = this.prefs.getInt("axisLabelFontColorGreen", 0);
        int b = this.prefs.getInt("axisLabelFontColorBlue", 0);
        return new Color(r, g, b);
    }

    public void setAxisLabelFontColor(Color axisLabelFontColor) {
        this.prefs.putInt("axisLabelFontColorRed", axisLabelFontColor.getRed());
        this.prefs.putInt("axisLabelFontColorGreen", axisLabelFontColor.getGreen());
        this.prefs.putInt("axisLabelFontColorBlue", axisLabelFontColor.getBlue());
    }

    public int getAxisLabelFontSize() {
        return this.prefs.getInt("axisLabelFontSize", 20);
    }

    public void setAxisLabelFontSize(int axisLabelFontSize) {
        this.prefs.putInt("axisLabelFontSize", axisLabelFontSize);
    }

    public int getAxisTicCount() {
        return this.prefs.getInt("axisTicCount", 11);
    }

    public void setAxisTicCount(int axisTicCount) {
        this.prefs.putInt("axisTicCount", axisTicCount);
    }

    public Color getAxisTicLabelFontColor() {
        int r = this.prefs.getInt("axisTicLabelFontColorRed", 0);
        int g = this.prefs.getInt("axisTicLabelFontColorGreen", 0);
        int b = this.prefs.getInt("axisTicLabelFontColorBlue", 0);
        return new Color(r, g, b);
    }

    public void setAxisTicLabelFontColor(Color axisTicLabelFontColor) {
        this.prefs.putInt("axisTicLabelFontColorRed", axisTicLabelFontColor.getRed());
        this.prefs.putInt("axisTicLabelFontColorGreen", axisTicLabelFontColor.getGreen());
        this.prefs.putInt("axisTicLabelFontColorBlue", axisTicLabelFontColor.getBlue());
    }

    public String getAxisTicLabelFormat() {
        return this.prefs.get("axisTicLabelFormat", "%4.3f");
    }

    public void setAxisTicLabelFormat(String axisTicLabelFormat) {
        this.prefs.put("axisTicLabelFormat", axisTicLabelFormat);
    }

    public int getAxisTicLength() {
        return this.prefs.getInt("axisTicLength", 4);
    }

    public void setAxisTicLength(int axisTicLength) {
        this.prefs.putInt("axisTicLength", axisTicLength);
    }

    public int getAxisWidth() {
        return this.prefs.getInt("axisWidth", 200);
    }

    public void setAxisWidth(int axisWidth) {
        this.prefs.putInt("axisWidth", axisWidth);
    }

    public Color getFilterDefaultColor() {
        int r = this.prefs.getInt("filterColorRed", 255);
        int g = this.prefs.getInt("filterColorGreen", 0);
        int b = this.prefs.getInt("filterColorBlue", 0);
        return new Color(r, g, b);
    }

    public void setFilterColor(Color filterColor) {
        this.prefs.putInt("filterColorRed", filterColor.getRed());
        this.prefs.putInt("filterColorGreen", filterColor.getGreen());
        this.prefs.putInt("filterColorBlue", filterColor.getBlue());
    }

    public int getFilterHeight() {
        return this.prefs.getInt("filterHeight", 7);
    }

    public void setFilterHeight(int filterHeight) {
        this.prefs.putInt("filterHeight", filterHeight);
    }

    public int getFilterWidth() {
        return this.prefs.getInt("filterWidth", 5);
    }

    public void setFilterWidth(int filterWidth) {
        this.prefs.putInt("filterWidth", filterWidth);
    }

    public int getAxisTicLabelFontSize() {
        return this.prefs.getInt("ticLabelFontSize", 10);
    }

    public void setAxisTicLabelFontSize(int ticLabelFontSize) {
        this.prefs.putInt("ticLabelFontSize", ticLabelFontSize);
    }

    public int getDesignLabelFontSize() {
        return this.prefs.getInt("designLabelFontSize", 10);
    }

    public void setDesignLabelFontSize(int designLabelFontSize) {
        this.prefs.putInt("designLabelFontSize", designLabelFontSize);
    }

    public int getDirToImportFrom() {
        return this.prefs.getInt("dirToImportFrom", 1);
    }

    public void setDirToImportFrom(int dirToImportFrom) {
        this.prefs.putInt("dirToImportFrom", dirToImportFrom);
    }

    public String getLastFile() {
        return this.prefs.get("lastFileBrowsingDirectory", System.getProperty("user.home"));
    }

    public void setLastFile(String lastFileBrowsingDirectory) {
        this.prefs.put("lastFileBrowsingDirectory", lastFileBrowsingDirectory);
    }

    public boolean isLastFileInitialised() {
        return this.prefs.getBoolean("lastFileInitialised", false);
    }

    public String getHomeDir() {
        return this.prefs.get("homeDir", System.getProperty("user.home"));
    }

    public void setHomeDir(String homeDir) {
        this.prefs.put("homeDir", homeDir);
    }

    public String getUserDir() {
        return this.prefs.get("userDir", System.getProperty("user.home"));
    }

    public void setUserDir(String userDir) {
        this.prefs.put("userDir", userDir);
    }

    public String getCurrentDir() {
        switch (this.getDirToImportFrom()) {
            case 0: {
                return this.getHomeDir();
            }
            case 1: {
                return this.getLastFile();
            }
            case 2: {
                return this.getUserDir();
            }
        }
        return this.getHomeDir();
    }

    public String getDelimiter() {
        return this.prefs.get("delimiter", "\\s");
    }

    public void setDelimiter(String delimiter) {
        this.prefs.put("delimiter", delimiter);
    }

    public boolean isTreatConsecutiveAsOne() {
        return this.prefs.getBoolean("treatConsecutiveAsOne", true);
    }

    public void setTreatConsecutiveAsOne(boolean treatConsecutiveAsOne) {
        this.prefs.putBoolean("treatConsecutiveAsOne", treatConsecutiveAsOne);
    }

    public String getOtherDelimiter() {
        return this.prefs.get("otherDelimiter", "");
    }

    public void setOtherDelimiter(String otherDelimiter) {
        this.prefs.put("otherDelimiter", otherDelimiter);
    }

    public boolean isShowFilteredDesigns() {
        return this.prefs.getBoolean("showFilteredDesigns", false);
    }

    public void setShowFilteredDesigns(boolean showFilteredDesigns) {
        this.prefs.putBoolean("showFilteredDesigns", showFilteredDesigns);
    }

    public Color getActiveDesignDefaultColor() {
        int r = this.prefs.getInt("activeDesignDefaultColorRed", 0);
        int g = this.prefs.getInt("activeDesignDefaultColorGreen", 255);
        int b = this.prefs.getInt("activeDesignDefaultColorBlue", 0);
        return new Color(r, g, b);
    }

    public void setActiveDesignDefaultColor(Color activeDesignDefaultColor) {
        this.prefs.putInt("activeDesignDefaultColorRed", activeDesignDefaultColor.getRed());
        this.prefs.putInt("activeDesignDefaultColorGreen", activeDesignDefaultColor.getGreen());
        this.prefs.putInt("activeDesignDefaultColorBlue", activeDesignDefaultColor.getBlue());
    }

    public Color getFilteredDesignDefaultColor() {
        int r = this.prefs.getInt("inActiveDesignDefaultColorRed", 100);
        int g = this.prefs.getInt("inActiveDesignDefaultColorGreen", 100);
        int b = this.prefs.getInt("inActiveDesignDefaultColorBlue", 100);
        return new Color(r, g, b);
    }

    public void setInActiveDesignDefaultColor(Color inActiveDesignDefaultColor) {
        this.prefs.putInt("inActiveDesignDefaultColorRed", inActiveDesignDefaultColor.getRed());
        this.prefs.putInt("inActiveDesignDefaultColorGreen", inActiveDesignDefaultColor.getGreen());
        this.prefs.putInt("inActiveDesignDefaultColorBlue", inActiveDesignDefaultColor.getBlue());
    }

    public boolean isShowDesignIDs() {
        return this.prefs.getBoolean("showDesignIDs", true);
    }

    public void setShowDesignIDs(boolean showDesignIDs) {
        this.prefs.putBoolean("showDesignIDs", showDesignIDs);
    }

    public int getDesignIDFontSize() {
        return this.prefs.getInt("designIDFontSize", 10);
    }

    public void setDesignIDFontSize(int designIDFontSize) {
        this.prefs.putInt("designIDFontSize", designIDFontSize);
    }

    public Color getDefaultBackgroundColor() {
        int r = this.prefs.getInt("backgroundColorRed", 255);
        int g = this.prefs.getInt("backgroundColorGreen", 255);
        int b = this.prefs.getInt("backgroundColorBlue", 255);
        return new Color(r, g, b);
    }

    public void setDefaultBackgroundColor(Color backgroundColor) {
        this.prefs.putInt("backgroundColorRed", backgroundColor.getRed());
        this.prefs.putInt("backgroundColorGreen", backgroundColor.getGreen());
        this.prefs.putInt("backgroundColorBlue", backgroundColor.getBlue());
    }

    public boolean isFilterInverted() {
        return this.prefs.getBoolean("filterInverted", false);
    }

    public void setFilterInverted(boolean filterInverted) {
        this.prefs.putBoolean("filterInverted", filterInverted);
    }

    public boolean isAxisInverted() {
        return this.prefs.getBoolean("axisInverted", false);
    }

    public void setAxisInverted(boolean axisInverted) {
        this.prefs.putBoolean("axisInverted", axisInverted);
    }

    public boolean isAutoFitAxis() {
        return this.prefs.getBoolean("autoFitAxis", true);
    }

    public void setAutoFitAxis(boolean autoFitAxis) {
        this.prefs.putBoolean("autoFitAxis", autoFitAxis);
    }

    public double getAxisDefaultMin() {
        return this.prefs.getDouble("axisDefaultMin", -10.0);
    }

    public void setAxisDefaultMin(double axisDefaultMin) {
        this.prefs.putDouble("axisDefaultMin", axisDefaultMin);
    }

    public double getAxisDefaultMax() {
        return this.prefs.getDouble("axisDefaultMax", 10.0);
    }

    public void setAxisDefaultMax(double axisDefaultMax) {
        this.prefs.putDouble("axisDefaultMax", axisDefaultMax);
    }

    public void resetToDefault() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            System.err.println(e.getMessage());
        }
        this.setLicenseAccepted(true);
    }

    private void log(String message) {
    }
}

