/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import actionListeners.AxisDisplaySettingsActionListener;
import actionListeners.ChartSpecificDisplaySettingsDialogActionListener;
import actionListeners.DefaultDisplaySettingsDialogActionListener;
import chart.Axis;
import chart.Chart;
import gui.buttons.ColorChoiceButton;
import gui.buttons.MinMaxSpinnerModel;
import gui.dialogs.DisplaySettingsDialog;
import gui.frames.ChartFrame;
import gui.panels.TitledSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import xdat.Main;
import xdat.UserPreferences;

public class AxisDisplaySettingsPanel
extends JPanel {
    static final long serialVersionUID = 0L;
    static final boolean printLog = false;
    private Main mainWindow;
    private DisplaySettingsDialog dialog;
    private UserPreferences userPreferences;
    private AxisDisplaySettingsActionListener cmd;
    private TitledSubPanel contentPanel = new TitledSubPanel("");
    private ColorChoiceButton axisColorButton;
    private ColorChoiceButton axisLabelColorButton;
    private JSpinner axisLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JSpinner axisWidthSpinner = new JSpinner(new MinMaxSpinnerModel(0, 1000));
    private JSpinner ticSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JSpinner ticCountSpinner = new JSpinner(new MinMaxSpinnerModel(1, 500));
    private ColorChoiceButton ticLabelColorButton;
    private JSpinner ticLabelFontSizeSpinner = new JSpinner(new MinMaxSpinnerModel(0, 100));
    private JRadioButton invertFilterTrueButton = new JRadioButton("Yes");
    private JRadioButton invertFilterFalseButton = new JRadioButton("No");
    private JRadioButton invertAxisTrueButton = new JRadioButton("Yes");
    private JRadioButton invertAxisFalseButton = new JRadioButton("No");
    private JRadioButton autoFitAxisTrueButton = new JRadioButton("Yes");
    private JRadioButton autoFitAxisFalseButton = new JRadioButton("No");
    private JTextField axisMinTextField = new JTextField();
    private JTextField axisMaxTextField = new JTextField();
    private ButtonGroup invertFilterButtonGroup = new ButtonGroup();
    private ButtonGroup invertAxisButtonGroup = new ButtonGroup();
    private ButtonGroup autoFitAxisButtonGroup = new ButtonGroup();
    private JComboBox axisChoiceCombo;
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton("Ok");
    private ChartFrame chartFrame;

    public AxisDisplaySettingsPanel(Main mainWindow, DisplaySettingsDialog dialog) {
        this.mainWindow = mainWindow;
        this.userPreferences = Main.getUserPreferences();
        this.dialog = dialog;
        this.buildPanel();
        this.setInvertFilterSelection(this.userPreferences.isFilterInverted());
        this.setInvertAxisSelection(this.userPreferences.isAxisInverted());
        this.setAutoFitAxisSelection(this.userPreferences.isAutoFitAxis());
        this.axisLabelFontSizeSpinner.setValue(this.userPreferences.getAxisLabelFontSize());
        this.axisWidthSpinner.setValue(this.userPreferences.getAxisWidth());
        this.ticSizeSpinner.setValue(this.userPreferences.getAxisTicLength());
        this.ticCountSpinner.setValue(this.userPreferences.getAxisTicCount());
        this.ticLabelFontSizeSpinner.setValue(this.userPreferences.getAxisTicLabelFontSize());
        Dimension maxMinTextFieldsPreferredSizes = new Dimension(60, 25);
        this.axisMinTextField.setText(Double.toString(this.userPreferences.getAxisDefaultMin()));
        this.axisMaxTextField.setText(Double.toString(this.userPreferences.getAxisDefaultMax()));
        this.axisMinTextField.setPreferredSize(maxMinTextFieldsPreferredSizes);
        this.axisMaxTextField.setPreferredSize(maxMinTextFieldsPreferredSizes);
    }

    public AxisDisplaySettingsPanel(Main mainWindow, DisplaySettingsDialog dialog, ChartFrame chartFrame) {
        this.mainWindow = mainWindow;
        this.userPreferences = Main.getUserPreferences();
        this.dialog = dialog;
        this.chartFrame = chartFrame;
        Chart chart = chartFrame.getChart();
        this.buildPanel();
        Vector<String> axes = new Vector<String>(0, 1);
        int i = 0;
        while (i < chart.getAxisCount()) {
            if (chart.getAxis(i).isActive()) {
                axes.add(chart.getAxis(i).getName());
            }
            ++i;
        }
        this.axisChoiceCombo = new JComboBox(axes);
        this.axisChoiceCombo.setSelectedIndex(0);
        this.axisChoiceCombo.setPreferredSize(new Dimension(100, 25));
        this.contentPanel.add((Component)this.axisChoiceCombo, "North");
        this.setStates(chart.getAxis(0));
    }

    public void setStates(Axis axis) {
        this.setInvertFilterSelection(axis.isFilterInverted());
        this.setInvertAxisSelection(axis.isAxisInverted());
        this.setAutoFitAxisSelection(axis.isAutoFit());
        this.log("setStates: setting InvertAxisSelection to " + axis.isAxisInverted());
        this.axisLabelFontSizeSpinner.setValue(axis.getAxisLabelFontSize());
        this.axisWidthSpinner.setValue(axis.getWidth());
        this.ticSizeSpinner.setValue(axis.getTicLength());
        this.ticCountSpinner.setValue(axis.getTicCount());
        this.ticLabelFontSizeSpinner.setValue(axis.getTicLabelFontSize());
        this.axisColorButton.setCurrentColor(axis.getAxisColor());
        this.axisLabelColorButton.setCurrentColor(axis.getAxisLabelFontColor());
        this.ticLabelColorButton.setCurrentColor(axis.getAxisTicLabelFontColor());
        this.setAutoFitAxisSelection(axis.isAutoFit());
        if (axis.getParameter().isNumeric()) {
            this.autoFitAxisFalseButton.setEnabled(true);
            this.autoFitAxisTrueButton.setEnabled(true);
            this.axisMinTextField.setText(Double.toString(axis.getMin()));
            this.axisMaxTextField.setText(Double.toString(axis.getMax()));
        } else {
            this.autoFitAxisFalseButton.setEnabled(false);
            this.autoFitAxisTrueButton.setEnabled(false);
            this.log("setStates: setting min text field to " + axis.getParameter().getStringValueOf(axis.getMin()));
            this.axisMinTextField.setText(axis.getParameter().getStringValueOf(axis.getMin()));
            this.log("setStates: setting max text field to " + axis.getParameter().getStringValueOf(axis.getMax()));
            this.axisMaxTextField.setText(axis.getParameter().getStringValueOf(axis.getMax()));
        }
        this.dialog.repaint();
    }

    private void buildPanel() {
        TitledSubPanel buttonsPanel = new TitledSubPanel("");
        JPanel labelPanel = new JPanel(new GridLayout(0, 1));
        JPanel controlsPanel = new JPanel(new GridLayout(0, 1));
        JPanel invertFilterRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel invertAxisRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel autoFitAxisRadioButtonsPanel = new JPanel(new GridLayout(1, 2));
        JPanel cancelButtonPanel = new JPanel();
        JPanel okButtonPanel = new JPanel();
        JLabel axisColorLabel = new JLabel("Axis Color");
        JLabel axisLabelColorLabel = new JLabel("Axis Label Color");
        JLabel axisLabelFontSizeLabel = new JLabel("Axis Label Fontsize");
        JLabel axisWidthLabel = new JLabel("Axis Spacing");
        JLabel ticSizeLabel = new JLabel("Tic Size");
        JLabel nrOfTicsLabel = new JLabel("Number of Tics");
        JLabel ticLabelColorLabel = new JLabel("Tic Label Color");
        JLabel ticLabelFontSizeLabel = new JLabel("Tic Label Font Size");
        JLabel invertFilterLabel = new JLabel("Invert Filter");
        JLabel invertAxisLabel = new JLabel("Invert Axis");
        JLabel autoFitAxisLabel = new JLabel("Autofit Axis");
        JLabel axisMinLabel = new JLabel("Min");
        JLabel axisMaxLabel = new JLabel("Max");
        this.axisColorButton = new ColorChoiceButton(Main.getUserPreferences().getAxisColor(), "Axis Color");
        this.axisLabelColorButton = new ColorChoiceButton(Main.getUserPreferences().getAxisLabelFontColor(), "Axis Label Color");
        this.ticLabelColorButton = new ColorChoiceButton(Main.getUserPreferences().getAxisTicLabelFontColor(), "Tic Label Color");
        this.invertFilterButtonGroup.add(this.invertFilterTrueButton);
        this.invertFilterButtonGroup.add(this.invertFilterFalseButton);
        this.invertAxisButtonGroup.add(this.invertAxisTrueButton);
        this.invertAxisButtonGroup.add(this.invertAxisFalseButton);
        this.autoFitAxisButtonGroup.add(this.autoFitAxisTrueButton);
        this.autoFitAxisButtonGroup.add(this.autoFitAxisFalseButton);
        this.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        cancelButtonPanel.setLayout(new FlowLayout(2));
        okButtonPanel.setLayout(new FlowLayout(0));
        buttonsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)buttonsPanel, "South");
        this.contentPanel.add((Component)labelPanel, "Center");
        this.contentPanel.add((Component)controlsPanel, "East");
        labelPanel.add(axisColorLabel);
        JPanel axisColorButtonPanel = new JPanel(new FlowLayout(0));
        axisColorButtonPanel.add(this.axisColorButton);
        controlsPanel.add(axisColorButtonPanel);
        labelPanel.add(axisLabelColorLabel);
        JPanel axisLabelColorButtonPanel = new JPanel(new FlowLayout(0));
        axisLabelColorButtonPanel.add(this.axisLabelColorButton);
        controlsPanel.add(axisLabelColorButtonPanel);
        labelPanel.add(axisLabelFontSizeLabel);
        controlsPanel.add(this.axisLabelFontSizeSpinner);
        labelPanel.add(axisWidthLabel);
        controlsPanel.add(this.axisWidthSpinner);
        labelPanel.add(ticSizeLabel);
        controlsPanel.add(this.ticSizeSpinner);
        labelPanel.add(nrOfTicsLabel);
        controlsPanel.add(this.ticCountSpinner);
        labelPanel.add(ticLabelColorLabel);
        JPanel ticLabelColorButtonPanel = new JPanel(new FlowLayout(0));
        ticLabelColorButtonPanel.add(this.ticLabelColorButton);
        controlsPanel.add(ticLabelColorButtonPanel);
        labelPanel.add(ticLabelFontSizeLabel);
        controlsPanel.add(this.ticLabelFontSizeSpinner);
        labelPanel.add(invertFilterLabel);
        invertFilterRadioButtonsPanel.add(this.invertFilterTrueButton);
        invertFilterRadioButtonsPanel.add(this.invertFilterFalseButton);
        this.invertFilterTrueButton.setActionCommand("invertFilterTrue");
        this.invertFilterFalseButton.setActionCommand("invertFilterFalse");
        controlsPanel.add(invertFilterRadioButtonsPanel);
        labelPanel.add(invertAxisLabel);
        invertAxisRadioButtonsPanel.add(this.invertAxisTrueButton);
        invertAxisRadioButtonsPanel.add(this.invertAxisFalseButton);
        this.invertAxisTrueButton.setActionCommand("invertAxisTrue");
        this.invertAxisFalseButton.setActionCommand("invertAxisFalse");
        controlsPanel.add(invertAxisRadioButtonsPanel);
        labelPanel.add(autoFitAxisLabel);
        autoFitAxisRadioButtonsPanel.add(this.autoFitAxisTrueButton);
        autoFitAxisRadioButtonsPanel.add(this.autoFitAxisFalseButton);
        this.autoFitAxisTrueButton.setActionCommand("autoFitAxisTrue");
        this.autoFitAxisFalseButton.setActionCommand("autoFitAxisFalse");
        controlsPanel.add(autoFitAxisRadioButtonsPanel);
        labelPanel.add(axisMinLabel);
        controlsPanel.add(this.axisMinTextField);
        labelPanel.add(axisMaxLabel);
        controlsPanel.add(this.axisMaxTextField);
        buttonsPanel.add(cancelButtonPanel);
        buttonsPanel.add(okButtonPanel);
        cancelButtonPanel.add(this.cancelButton);
        okButtonPanel.add(this.okButton);
    }

    public void setActionListener(AxisDisplaySettingsActionListener cmd) {
        this.cmd = cmd;
        this.axisColorButton.addActionListener(cmd);
        this.axisLabelColorButton.addActionListener(cmd);
        this.ticLabelColorButton.addActionListener(cmd);
        this.invertFilterTrueButton.addActionListener(cmd);
        this.invertFilterFalseButton.addActionListener(cmd);
        this.invertAxisTrueButton.addActionListener(cmd);
        this.invertAxisFalseButton.addActionListener(cmd);
        this.autoFitAxisTrueButton.addActionListener(cmd);
        this.autoFitAxisFalseButton.addActionListener(cmd);
        if (this.axisChoiceCombo != null) {
            this.axisChoiceCombo.addActionListener(cmd);
        }
        this.axisLabelFontSizeSpinner.addChangeListener(cmd);
        this.axisWidthSpinner.addChangeListener(cmd);
        this.ticSizeSpinner.addChangeListener(cmd);
        this.ticCountSpinner.addChangeListener(cmd);
        this.ticLabelFontSizeSpinner.addChangeListener(cmd);
    }

    public void setOkCancelButtonTargetDefaultSettings() {
        DefaultDisplaySettingsDialogActionListener cmd = new DefaultDisplaySettingsDialogActionListener(this.mainWindow, this.dialog);
        this.log("setOkCancelButtonTargetDefaultSettings called");
        this.cancelButton.addActionListener(cmd);
        this.okButton.addActionListener(cmd);
    }

    public void setOkCancelButtonTargetChart(Chart chart) {
        this.log("setOkCancelButtonTargetChart called");
        this.cancelButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
        this.okButton.addActionListener(new ChartSpecificDisplaySettingsDialogActionListener(this.mainWindow, this.dialog, chart, this.chartFrame));
    }

    public AxisDisplaySettingsActionListener getAxisDisplaySettingsActionListener() {
        return this.cmd;
    }

    public void setInvertFilterSelection(boolean invertFilterSelection) {
        if (invertFilterSelection) {
            this.invertFilterButtonGroup.setSelected(this.invertFilterTrueButton.getModel(), true);
        } else {
            this.invertFilterButtonGroup.setSelected(this.invertFilterFalseButton.getModel(), true);
        }
    }

    public boolean getInvertFilterSelection() {
        return this.invertFilterTrueButton.getModel().equals(this.invertFilterButtonGroup.getSelection());
    }

    public void setInvertAxisSelection(boolean invertAxisSelection) {
        if (invertAxisSelection) {
            this.invertAxisButtonGroup.setSelected(this.invertAxisTrueButton.getModel(), true);
        } else {
            this.invertAxisButtonGroup.setSelected(this.invertAxisFalseButton.getModel(), true);
        }
    }

    public boolean getInvertAxisSelection() {
        return this.invertAxisTrueButton.getModel().equals(this.invertAxisButtonGroup.getSelection());
    }

    public void setAutoFitAxisSelection(boolean autoFitAxisSelection) {
        if (autoFitAxisSelection) {
            this.autoFitAxisButtonGroup.setSelected(this.autoFitAxisTrueButton.getModel(), true);
            this.axisMaxTextField.setEnabled(false);
            this.axisMinTextField.setEnabled(false);
        } else {
            this.autoFitAxisButtonGroup.setSelected(this.autoFitAxisFalseButton.getModel(), true);
            this.axisMaxTextField.setEnabled(true);
            this.axisMinTextField.setEnabled(true);
        }
    }

    public boolean getAutoFitAxisSelection() {
        return this.autoFitAxisTrueButton.getModel().equals(this.autoFitAxisButtonGroup.getSelection());
    }

    private void log(String message) {
    }

    public JSpinner getAxisLabelFontSizeSpinner() {
        return this.axisLabelFontSizeSpinner;
    }

    public JSpinner getTicCountSpinner() {
        return this.ticCountSpinner;
    }

    public JSpinner getTicLabelFontSizeSpinner() {
        return this.ticLabelFontSizeSpinner;
    }

    public JSpinner getTicSizeSpinner() {
        return this.ticSizeSpinner;
    }

    public JSpinner getAxisWidthSpinner() {
        return this.axisWidthSpinner;
    }

    public ColorChoiceButton getAxisColorButton() {
        return this.axisColorButton;
    }

    public ColorChoiceButton getAxisLabelColorButton() {
        return this.axisLabelColorButton;
    }

    public ColorChoiceButton getTicLabelColorButton() {
        return this.ticLabelColorButton;
    }

    public JComboBox getAxisChoiceCombo() {
        return this.axisChoiceCombo;
    }

    public ChartFrame getChartFrame() {
        return this.chartFrame;
    }

    public double getAxisMax() {
        double max = this.chartFrame == null ? Main.getUserPreferences().getAxisDefaultMax() : this.chartFrame.getChart().getAxis(this.axisChoiceCombo.getSelectedItem().toString()).getMax();
        try {
            return Double.parseDouble(this.axisMaxTextField.getText());
        }
        catch (NumberFormatException e) {
            this.axisMaxTextField.setText(Double.toString(max));
            return max;
        }
    }

    public double getAxisMin() {
        double min = this.chartFrame == null ? Main.getUserPreferences().getAxisDefaultMin() : this.chartFrame.getChart().getAxis(this.axisChoiceCombo.getSelectedItem().toString()).getMin();
        try {
            return Double.parseDouble(this.axisMinTextField.getText());
        }
        catch (NumberFormatException e) {
            this.axisMinTextField.setText(Double.toString(min));
            return min;
        }
    }

    public void setAxisRangeFieldsEnabled(boolean fieldsEnabled) {
        this.axisMinTextField.setEnabled(fieldsEnabled);
        this.axisMaxTextField.setEnabled(fieldsEnabled);
    }
}

