/*
 * Decompiled with CFR 0.152.
 */
package gui.frames;

import chart.Chart;
import gui.ChartFrameClosingAdapter;
import gui.menus.ChartFrameAddDesignToClusterMenu;
import gui.menus.ChartFrameMenuBar;
import gui.menus.ChartFrameSelectParametersMenu;
import gui.panels.ChartPanel;
import java.awt.GridLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import xdat.Main;

public class ChartFrame
extends JFrame
implements ComponentListener {
    static final long serialVersionUID = 1L;
    static final boolean printLog = false;
    private Main mainWindow;
    private Chart chart;
    private ChartPanel chartPanel;
    private ChartFrameAddDesignToClusterMenu clusterMenu;
    private ChartFrameSelectParametersMenu selectParametersMenu;

    public ChartFrame(Main mainWindow, Chart chart) {
        super("Chart");
        this.log("constructor invoked.");
        this.addWindowListener(new ChartFrameClosingAdapter(this, mainWindow));
        this.mainWindow = mainWindow;
        this.chart = chart;
        mainWindow.addChartFrame(this);
        this.setJMenuBar(new ChartFrameMenuBar(mainWindow, this, chart));
        this.setLayout(new GridLayout(1, 1));
        this.chartPanel = new ChartPanel(mainWindow.getDataSheet(), this.chart);
        JScrollPane scrollPane = new JScrollPane(this.chartPanel, 22, 32);
        this.add(scrollPane);
        this.setLocation(this.chart.getLocation());
        this.setSize(this.chart.getSize());
        this.addComponentListener(this);
        this.setVisible(true);
    }

    public Chart getChart() {
        return this.chart;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    @Override
    public void dispose() {
        this.log("dispose called");
        this.mainWindow.removeChartFrame(this);
        super.dispose();
    }

    private void log(String message) {
    }

    public ChartFrameAddDesignToClusterMenu getClusterMenu() {
        return this.clusterMenu;
    }

    public void setClusterMenu(ChartFrameAddDesignToClusterMenu clusterMenu) {
        this.clusterMenu = clusterMenu;
    }

    public ChartFrameSelectParametersMenu getSelectParametersMenu() {
        return this.selectParametersMenu;
    }

    public void setSelectParametersMenu(ChartFrameSelectParametersMenu selectParametersMenu) {
        this.selectParametersMenu = selectParametersMenu;
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.chart.setLocation(this.getLocation());
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.chart.setSize(this.getSize());
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

