/*
 * Decompiled with CFR 0.152.
 */
package gui.dialogs;

import actionListeners.FileImportSettingsDialogActionListener;
import gui.WindowClosingAdapter;
import gui.panels.TitledSubPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import xdat.Main;

public class FileImportSettingsDialog
extends JDialog {
    static final long serialVersionUID = 1L;
    private static final boolean printLog = false;
    private Main mainWindow;
    private ButtonGroup fileBrowsingButtonGroup = new ButtonGroup();
    private ButtonGroup delimiterButtonGroup = new ButtonGroup();
    private JTextField otherTextField;
    private JTextField useThisTextField;
    private JCheckBox treatConsecutiveAsOneCheckBox;
    JRadioButton spaceRadioButton = new JRadioButton("Space");
    JRadioButton tabRadioButton = new JRadioButton("Tabstop");
    JRadioButton allBlanksRadioButton = new JRadioButton("Any Blank Space");
    JRadioButton commaRadioButton = new JRadioButton("Comma");
    JRadioButton semiColonRadioButton = new JRadioButton("Semi-colon");
    JRadioButton otherRadioButton = new JRadioButton("Other: ");
    JRadioButton useHomeRadioButton = new JRadioButton("Use home directory");
    JRadioButton useLastRadioButton = new JRadioButton("Use last opened directory");
    JRadioButton useThisRadioButton = new JRadioButton("Use this directory:  ");

    public FileImportSettingsDialog(Main mainWindow) throws HeadlessException {
        super(mainWindow, "File Import Settings", true);
        FileImportSettingsDialog.log("constructor called");
        this.addWindowListener(new WindowClosingAdapter(false));
        this.setResizable(false);
        this.mainWindow = mainWindow;
        TitledSubPanel fileBrowsingSettingsPanel = new TitledSubPanel("File Browsing default Location");
        TitledSubPanel delimiterPanel = new TitledSubPanel("Delimiters");
        TitledSubPanel buttonsPanel = new TitledSubPanel("");
        JPanel useThisPathPanel = new JPanel();
        this.fileBrowsingButtonGroup.add(this.useHomeRadioButton);
        this.fileBrowsingButtonGroup.add(this.useLastRadioButton);
        this.fileBrowsingButtonGroup.add(this.useThisRadioButton);
        if (Main.getUserPreferences().getDirToImportFrom() == 0) {
            this.fileBrowsingButtonGroup.setSelected(this.useHomeRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDirToImportFrom() == 1) {
            this.fileBrowsingButtonGroup.setSelected(this.useLastRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDirToImportFrom() == 2) {
            this.fileBrowsingButtonGroup.setSelected(this.useThisRadioButton.getModel(), true);
        }
        this.useThisTextField = new JTextField();
        this.useThisTextField.setText(Main.getUserPreferences().getUserDir());
        this.useThisTextField.setPreferredSize(new Dimension(250, 25));
        JButton useThisBrowseButton = new JButton("...");
        JPanel otherPanel = new JPanel();
        this.otherTextField = new JTextField();
        this.otherTextField.setText(Main.getUserPreferences().getOtherDelimiter());
        this.delimiterButtonGroup.add(this.spaceRadioButton);
        this.delimiterButtonGroup.add(this.tabRadioButton);
        this.delimiterButtonGroup.add(this.allBlanksRadioButton);
        this.delimiterButtonGroup.add(this.commaRadioButton);
        this.delimiterButtonGroup.add(this.semiColonRadioButton);
        this.delimiterButtonGroup.add(this.otherRadioButton);
        if (Main.getUserPreferences().getDelimiter().equals(" ")) {
            this.delimiterButtonGroup.setSelected(this.spaceRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDelimiter().equals("\\t")) {
            this.delimiterButtonGroup.setSelected(this.tabRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDelimiter().equals(",")) {
            this.delimiterButtonGroup.setSelected(this.commaRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDelimiter().equals(";")) {
            this.delimiterButtonGroup.setSelected(this.semiColonRadioButton.getModel(), true);
        } else if (Main.getUserPreferences().getDelimiter().equals(this.otherTextField.getText())) {
            this.delimiterButtonGroup.setSelected(this.otherRadioButton.getModel(), true);
        } else {
            this.delimiterButtonGroup.setSelected(this.allBlanksRadioButton.getModel(), true);
        }
        this.treatConsecutiveAsOneCheckBox = new JCheckBox("Treat consecutive delimiters as one");
        this.treatConsecutiveAsOneCheckBox.setSelected(Main.getUserPreferences().isTreatConsecutiveAsOne());
        JPanel cancelButtonPanel = new JPanel();
        JPanel okButtonPanel = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        this.setLayout(new BorderLayout());
        fileBrowsingSettingsPanel.setLayout(new GridLayout(3, 1));
        useThisPathPanel.setLayout(new BorderLayout());
        delimiterPanel.setLayout(new GridLayout(4, 2));
        otherPanel.setLayout(new GridLayout(1, 2));
        cancelButtonPanel.setLayout(new FlowLayout(2));
        okButtonPanel.setLayout(new FlowLayout(0));
        buttonsPanel.setLayout(new GridLayout(1, 2));
        this.add((Component)fileBrowsingSettingsPanel, "North");
        this.add((Component)delimiterPanel, "Center");
        this.add((Component)buttonsPanel, "South");
        fileBrowsingSettingsPanel.add(this.useHomeRadioButton);
        fileBrowsingSettingsPanel.add(this.useLastRadioButton);
        useThisPathPanel.add((Component)this.useThisRadioButton, "West");
        useThisPathPanel.add((Component)this.useThisTextField, "Center");
        useThisPathPanel.add((Component)useThisBrowseButton, "East");
        fileBrowsingSettingsPanel.add(useThisPathPanel);
        delimiterPanel.add(this.spaceRadioButton);
        delimiterPanel.add(this.semiColonRadioButton);
        delimiterPanel.add(this.tabRadioButton);
        delimiterPanel.add(otherPanel);
        otherPanel.add(this.otherRadioButton);
        otherPanel.add(this.otherTextField);
        delimiterPanel.add(this.allBlanksRadioButton);
        delimiterPanel.add(new JPanel());
        delimiterPanel.add(this.commaRadioButton);
        delimiterPanel.add(this.treatConsecutiveAsOneCheckBox);
        buttonsPanel.add(cancelButtonPanel);
        buttonsPanel.add(okButtonPanel);
        cancelButtonPanel.add(cancelButton);
        okButtonPanel.add(okButton);
        FileImportSettingsDialogActionListener cmd = new FileImportSettingsDialogActionListener(mainWindow, this);
        useThisBrowseButton.addActionListener(cmd);
        cancelButton.addActionListener(cmd);
        okButton.addActionListener(cmd);
        this.pack();
        int left = (int)(0.5 * (double)this.mainWindow.getSize().width) - (int)((double)this.getSize().width * 0.5) + this.mainWindow.getLocation().x;
        int top = (int)(0.5 * (double)this.mainWindow.getSize().height) - (int)((double)this.getSize().height * 0.5) + this.mainWindow.getLocation().y;
        this.setLocation(left, top);
        this.setVisible(true);
    }

    private static final void log(String message) {
    }

    public ButtonGroup getDelimiterButtonGroup() {
        return this.delimiterButtonGroup;
    }

    public ButtonGroup getFileBrowsingButtonGroup() {
        return this.fileBrowsingButtonGroup;
    }

    public JTextField getOtherTextField() {
        return this.otherTextField;
    }

    public JTextField getUseThisTextField() {
        return this.useThisTextField;
    }

    public JCheckBox getTreatConsecutiveAsOneCheckBox() {
        return this.treatConsecutiveAsOneCheckBox;
    }

    public JRadioButton getAllBlanksRadioButton() {
        return this.allBlanksRadioButton;
    }

    public JRadioButton getOtherRadioButton() {
        return this.otherRadioButton;
    }

    public JRadioButton getSemiColonRadioButton() {
        return this.semiColonRadioButton;
    }

    public JRadioButton getSpaceRadioButton() {
        return this.spaceRadioButton;
    }

    public JRadioButton getTabRadioButton() {
        return this.tabRadioButton;
    }

    public JRadioButton getUseHomeRadioButton() {
        return this.useHomeRadioButton;
    }

    public JRadioButton getUseLastRadioButton() {
        return this.useLastRadioButton;
    }

    public JRadioButton getUseThisRadioButton() {
        return this.useThisRadioButton;
    }

    public JRadioButton getCommaRadioButton() {
        return this.commaRadioButton;
    }
}

