/*
 * Decompiled with CFR 0.152.
 */
package data;

import exceptions.CorruptDataException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class Parameter
implements Serializable {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    private String name;
    private boolean numeric = true;
    private TreeSet<String> discreteLevels = new TreeSet<String>(new ReverseStringComparator());

    public Parameter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public void setNumeric(boolean numeric) {
        this.numeric = numeric;
    }

    public double getDoubleValueOf(String string) {
        if (this.numeric) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException e) {
                this.setNumeric(false);
            }
        }
        int index = 0;
        Iterator<String> it = this.discreteLevels.iterator();
        this.log("getDoubleValueOf: checking index of string " + string);
        while (it.hasNext()) {
            if (string.equalsIgnoreCase(it.next())) {
                return index;
            }
            ++index;
        }
        this.log("getDoubleValueOf: string " + string + " not found, adding it to tree set ");
        this.discreteLevels.add(string);
        index = 0;
        it = this.discreteLevels.iterator();
        this.log("getDoubleValueOf: re-checking index of string " + string);
        while (it.hasNext()) {
            if (string.equalsIgnoreCase(it.next())) {
                return index;
            }
            ++index;
        }
        throw new CorruptDataException(this);
    }

    public String getStringValueOf(double value) {
        if (this.numeric) {
            this.log("getStringValueOf: Parameter " + this.name + " is numeric. Returning " + Double.toString(value));
            return Double.toString(value);
        }
        this.log("getStringValueOf: Parameter " + this.name + " is not numeric. ");
        this.log("value = " + value);
        int index = (int)value;
        this.log("getStringValueOf: index is " + index);
        int currentIndex = 0;
        Iterator<String> it = this.discreteLevels.iterator();
        while (it.hasNext()) {
            this.log("getStringValueOf: checking currentIndex " + currentIndex + " against index " + index);
            String next = it.next();
            if (currentIndex == index) {
                this.log("getStringValueOf: check positive. Returning string " + next);
                return next;
            }
            ++currentIndex;
        }
        throw new CorruptDataException(this);
    }

    public int getDiscreteLevelCount() {
        if (this.isNumeric()) {
            throw new RuntimeException("Parameter " + this.name + " is numeric!");
        }
        return this.discreteLevels.size();
    }

    public void resetDiscreteLevels() {
        this.log("resetDiscreteLevels called");
        this.discreteLevels = new TreeSet<String>(new ReverseStringComparator());
    }

    private void log(String message) {
    }

    class ReverseStringComparator
    implements Comparator<String>,
    Serializable {
        static final long serialVersionUID = 0L;

        ReverseStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s2.compareToIgnoreCase(s1);
        }
    }
}

