/*
 * Decompiled with CFR 0.152.
 */
package data;

import chart.Axis;
import chart.Chart;
import chart.Filter;
import data.Cluster;
import data.Parameter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import xdat.Main;

public class Design
implements Serializable {
    static final long serialVersionUID = 4L;
    static final boolean printLog = true;
    private Hashtable<Parameter, String> parameterValues = new Hashtable(0, 1.0f);
    private int id;
    private Cluster cluster;
    private Hashtable<Filter, Boolean> activationMap = new Hashtable(0, 1.0f);
    private boolean insideBounds;

    public Design(int id) {
        this.id = id;
    }

    public void setValue(Parameter param, String parameterValue) {
        this.parameterValues.put(param, parameterValue);
        if (param.isNumeric()) {
            try {
                Double.parseDouble(parameterValue);
            }
            catch (NumberFormatException e) {
                this.log("setValue: parameterValue " + parameterValue + " was not recogized as numeric. Parameter " + param.getName() + " set to non-numeric.");
                param.setNumeric(false);
            }
        }
    }

    public double getDoubleValue(Parameter param) {
        if (this.parameterValues.containsKey(param)) {
            return param.getDoubleValueOf(this.parameterValues.get(param));
        }
        Enumeration<Parameter> e = this.parameterValues.keys();
        this.log("getDoubleValue: parameterValues.containsKey(param) = " + this.parameterValues.containsKey(param));
        while (e.hasMoreElements()) {
            this.log("getDoubleValue: parameterValues has key " + e.nextElement().getName());
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public String getStringValue(Parameter param) {
        if (this.parameterValues.containsKey(param)) {
            return this.parameterValues.get(param);
        }
        throw new IllegalArgumentException("Unknown parameter " + param.getName());
    }

    public boolean isActive(Chart chart) {
        int i = 0;
        while (i < chart.getAxisCount()) {
            Filter uf = chart.getAxis(i).getUpperFilter();
            Filter lf = chart.getAxis(i).getLowerFilter();
            if (!this.activationMap.containsKey(uf)) {
                this.activationMap.put(uf, true);
            }
            if (!this.activationMap.containsKey(lf)) {
                this.activationMap.put(lf, true);
            }
            if (chart.getAxis(i).isFilterInverted()) {
                if (!this.activationMap.get(uf).booleanValue() && !this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            } else {
                if (!this.activationMap.get(uf).booleanValue()) {
                    return false;
                }
                if (!this.activationMap.get(lf).booleanValue()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public void setActive(Filter filter, boolean active) {
        this.activationMap.put(filter, active);
    }

    public void evaluateBounds(Chart chart) {
        this.insideBounds = true;
        int i = 0;
        while (i < chart.getAxisCount()) {
            if (!this.isInsideBounds(chart.getAxis(i))) {
                this.insideBounds = false;
                return;
            }
            ++i;
        }
    }

    private boolean isInsideBounds(Axis axis) {
        double value = this.getDoubleValue(axis.getParameter());
        double max = axis.getMax();
        double min = axis.getMin();
        return min <= value && value <= max;
    }

    public boolean isInsideBounds(Chart chart) {
        return this.insideBounds;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    private void log(String message) {
        if (Main.isLoggingEnabled()) {
            System.out.println(String.valueOf(this.getClass().getName()) + "." + message);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }
}

