/*
 * Decompiled with CFR 0.152.
 */
package data;

import chart.Chart;
import data.ClusterSet;
import data.Design;
import data.Parameter;
import exceptions.InconsistentDataException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import xdat.Main;
import xdat.UserPreferences;

public class DataSheet
implements TableModel,
Serializable {
    static final long serialVersionUID = 6L;
    static final boolean printLog = false;
    private ClusterSet clusterSet;
    private Vector<Design> data = new Vector(0, 1);
    private Vector<Parameter> parameters = new Vector(0, 1);
    private transient Vector<TableModelListener> listeners = new Vector();
    private String delimiter;

    public DataSheet(String pathToInputFile, boolean dataHasHeaders) throws IOException {
        UserPreferences userPreferences = Main.getUserPreferences();
        this.clusterSet = new ClusterSet(this);
        this.delimiter = userPreferences.getDelimiter();
        if (userPreferences.isTreatConsecutiveAsOne()) {
            this.delimiter = String.valueOf(this.delimiter) + "+";
        }
        this.importData(pathToInputFile, dataHasHeaders);
    }

    private void checkParameters() {
        int j = 0;
        while (j < this.parameters.size()) {
            this.parameters.get(j).resetDiscreteLevels();
            int i = 0;
            while (i < this.data.size()) {
                this.log("checkParameters: checking parameter " + this.parameters.get(j).getName());
                this.log("checkParameters: parameter.isNumeric() before check: " + this.parameters.get(j).isNumeric());
                this.data.get(i).getDoubleValue(this.parameters.get(j));
                this.log("checkParameters: parameter.isNumeric() after check: " + this.parameters.get(j).isNumeric());
                ++i;
            }
            ++j;
        }
    }

    private void importData(String pathToInputFile, boolean dataHasHeaders) throws IOException {
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (dataHasHeaders) {
            int i = 0;
            while (i < lineElements.length) {
                this.parameters.add(new Parameter(this.getUniqueParameterName(lineElements[i])));
                ++i;
            }
        } else {
            Design newDesign = new Design(idCounter++);
            int i = 0;
            while (i < lineElements.length) {
                this.parameters.add(new Parameter("Parameter " + (i + 1)));
                newDesign.setValue(this.parameters.get(i), lineElements[i]);
                ++i;
            }
            this.data.add(newDesign);
        }
        while ((line = f.readLine()) != null) {
            lineElements = line.split(this.delimiter);
            if (lineElements.length < 1) continue;
            Design newDesign = new Design(idCounter++);
            boolean newDesignContainsValues = false;
            int i = 0;
            while (i < lineElements.length) {
                if (lineElements[i].length() > 0 && !lineElements[i].equals(new String("\\s"))) {
                    newDesignContainsValues = true;
                }
                ++i;
            }
            if (!newDesignContainsValues) continue;
            i = 0;
            while (i < this.parameters.size()) {
                if (lineElements.length <= i || lineElements[i].length() <= 0 || lineElements[i].equals(new String("\\s"))) {
                    newDesign.setValue(this.parameters.get(i), "-");
                } else {
                    newDesignContainsValues = true;
                    newDesign.setValue(this.parameters.get(i), lineElements[i]);
                }
                ++i;
            }
            this.data.add(newDesign);
        }
        f.close();
        this.checkParameters();
    }

    public void updateData(String pathToInputFile, boolean dataHasHeaders) throws IOException, InconsistentDataException {
        int idCounter = 1;
        BufferedReader f = new BufferedReader(new FileReader(pathToInputFile));
        String line = f.readLine().trim();
        String[] lineElements = line.split(this.delimiter);
        if (lineElements.length != this.getParameterCount()) {
            throw new InconsistentDataException(pathToInputFile);
        }
        this.data.removeAllElements();
        if (dataHasHeaders) {
            int i = 0;
            while (i < this.parameters.size()) {
                this.parameters.get(i).setName(null);
                ++i;
            }
            i = 0;
            while (i < lineElements.length) {
                this.parameters.get(i).setName(this.getUniqueParameterName(lineElements[i]));
                ++i;
            }
        } else {
            Design newDesign = new Design(idCounter++);
            int i = 0;
            while (i < this.parameters.size()) {
                if (lineElements.length <= i) {
                    newDesign.setValue(this.parameters.get(i), "-");
                } else {
                    newDesign.setValue(this.parameters.get(i), lineElements[i]);
                }
                ++i;
            }
            this.data.add(newDesign);
            this.data.add(newDesign);
        }
        while ((line = f.readLine()) != null) {
            lineElements = line.split(this.delimiter);
            if (lineElements.length < 1) continue;
            Design newDesign = new Design(idCounter++);
            boolean newDesignContainsValues = false;
            int i = 0;
            while (i < lineElements.length) {
                if (lineElements[i].length() > 0 && !lineElements[i].equals(new String("\\s"))) {
                    newDesignContainsValues = true;
                }
                ++i;
            }
            if (!newDesignContainsValues) continue;
            i = 0;
            while (i < this.parameters.size()) {
                if (lineElements.length <= i || lineElements[i].length() <= 0 || lineElements[i].equals(new String("\\s"))) {
                    newDesign.setValue(this.parameters.get(i), "-");
                } else {
                    newDesign.setValue(this.parameters.get(i), lineElements[i]);
                    newDesignContainsValues = true;
                }
                ++i;
            }
            this.data.add(newDesign);
        }
        f.close();
        this.checkParameters();
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.parameters.size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.parameters.get(columnIndex).getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.data.get(rowIndex).getId();
        }
        return this.data.get(rowIndex).getStringValue(this.parameters.get(columnIndex - 1));
    }

    @Override
    public void setValueAt(Object arg0, int rowIndex, int columnIndex) {
        try {
            this.data.get(rowIndex).setValue(this.parameters.get(columnIndex - 1), arg0.toString());
            Double.parseDouble(arg0.toString());
        }
        catch (NumberFormatException e) {
            this.log("setValueAt: value " + arg0.toString() + " of parameter " + this.parameters.get(columnIndex - 1).getName() + " is not numeric.");
            this.parameters.get(columnIndex - 1).setNumeric(false);
            this.log("setValueAt: value " + arg0.toString() + " is not numeric.");
            this.checkParameters();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTableChanged() {
        TableModelEvent e = new TableModelEvent(this);
        int i = 0;
        int n = this.listeners.size();
        while (i < n) {
            this.listeners.get(i).tableChanged(e);
            ++i;
        }
    }

    public Design getDesign(int i) {
        return this.data.get(i);
    }

    public void addDesign(Design design) {
        this.data.add(design);
        this.fireTableChanged();
    }

    public void removeDesign(Design design) {
        this.data.remove(design);
        this.fireTableChanged();
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public String getParameterName(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index).getName();
    }

    public Parameter getParameter(int index) {
        if (index >= this.parameters.size() || index < 0) {
            throw new IllegalArgumentException("Invalid Index " + index);
        }
        return this.parameters.get(index);
    }

    public Parameter getParameter(String parameterName) {
        int i = 0;
        while (i < this.parameters.size()) {
            if (parameterName.equals(this.parameters.get(i).getName())) {
                return this.parameters.get(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Parameter " + parameterName + " not found");
    }

    public double getMaxValueOf(Parameter param) {
        if (param.isNumeric()) {
            double max = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                this.log("getMaxValueOf: max = " + max);
                if (max < this.data.get(i).getDoubleValue(param)) {
                    this.log("getMaxValueOf: Higher value found. New max = " + max);
                    max = this.data.get(i).getDoubleValue(param);
                }
                ++i;
            }
            this.log("getMaxValueOf: Final max = " + max);
            return max;
        }
        return param.getDiscreteLevelCount() - 1;
    }

    public double getMinValueOf(Parameter param) {
        if (param.isNumeric()) {
            double min = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.data.size()) {
                if (min > this.data.get(i).getDoubleValue(param)) {
                    min = this.data.get(i).getDoubleValue(param);
                }
                ++i;
            }
            return min;
        }
        return 0.0;
    }

    public int getDesignCount() {
        return this.data.size();
    }

    private String getUniqueParameterName(String nameSuggestion) {
        String name = nameSuggestion;
        int id = 2;
        while (!this.isNameUnique(name)) {
            name = String.valueOf(nameSuggestion) + " (" + id++ + ")";
        }
        return name;
    }

    private boolean isNameUnique(String name) {
        boolean unique = true;
        int i = 0;
        while (i < this.parameters.size()) {
            if (name.equals(this.parameters.get(i).getName())) {
                unique = false;
                break;
            }
            ++i;
        }
        return unique;
    }

    private void log(String message) {
    }

    public ClusterSet getClusterSet() {
        return this.clusterSet;
    }

    public void setClusterSet(ClusterSet clusterSet) {
        this.clusterSet = clusterSet;
    }

    public void evaluateBoundsForAllDesigns(Chart chart) {
        int i = 0;
        while (i < this.getDesignCount()) {
            this.data.get(i).evaluateBounds(chart);
            ++i;
        }
    }
}

