/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Axis;
import data.DataSheet;
import data.Parameter;
import java.io.Serializable;

public class Filter
implements Serializable {
    static final long serialVersionUID = 2L;
    static final boolean printLog = false;
    public static final int UPPER_FILTER = 0;
    public static final int LOWER_FILTER = 1;
    private DataSheet dataSheet;
    private int filterType;
    private Axis axis;
    private int xPos;
    private int yPos;

    public Filter(DataSheet dataSheet, Axis axis, int filterType) {
        this.log("constructor called");
        this.dataSheet = dataSheet;
        this.axis = axis;
        this.filterType = filterType;
        if (filterType == 0) {
            this.yPos = this.getHighestPos();
            this.log("constructor: filtertype is upper filter. Pos is " + this.yPos);
        } else {
            this.yPos = this.getLowestPos();
            this.log("constructor: filtertype is lower filter. Pos is " + this.yPos);
        }
    }

    public double getValue() {
        double upperLimit = this.axis.getMax();
        double lowerLimit = this.axis.getMin();
        double valueRange = upperLimit - lowerLimit;
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.axis.getHeight() + 1;
        double posRange = bottomPos - topPos;
        double ratio = this.axis.isAxisInverted() ? (double)(this.yPos - topPos) / posRange : (double)(bottomPos - this.yPos) / posRange;
        double value = lowerLimit + valueRange * ratio;
        return value;
    }

    public void setValue(double value) {
        int yPos;
        double ratio;
        this.log("****");
        this.log("setValue: setting value of filter " + this.filterType + " to: " + value);
        double upperLimit = this.axis.getMax();
        this.log("setValue: upperLimit of filter " + this.filterType + ": " + upperLimit);
        double lowerLimit = this.axis.getMin();
        this.log("setValue: lowerLimit of filter " + this.filterType + ": " + lowerLimit);
        if (value > upperLimit) {
            value = upperLimit;
        } else if (value < lowerLimit) {
            value = lowerLimit;
        }
        double valueRange = upperLimit - lowerLimit;
        this.log("setValue: valueRange of filter " + this.filterType + ": " + valueRange);
        int topPos = this.axis.getChart().getAxisTopPos() - 1;
        int bottomPos = topPos + this.axis.getHeight() + 1;
        double posRange = bottomPos - topPos;
        this.log("setValue: posRange of filter " + this.filterType + ": " + posRange);
        if (this.axis.isAxisInverted()) {
            ratio = (value - lowerLimit) / valueRange;
            yPos = topPos + (int)(posRange * ratio);
        } else {
            ratio = (value - lowerLimit) / valueRange;
            yPos = bottomPos - (int)(posRange * ratio);
        }
        this.log("setValue: ratio of filter " + this.filterType + ": " + ratio);
        this.log("setValue: setting value of filter " + this.filterType + " to ypos: " + yPos);
        this.setYPos(yPos);
        this.applyToDesigns();
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setXPos(int pos) {
        this.xPos = pos;
    }

    public int getYPos() {
        if (this.axis.getTicCount() == 1) {
            return this.getAxis().getChart().getAxisTopPos() + (int)((double)this.getAxis().getHeight() * 0.5);
        }
        return this.yPos;
    }

    public void setYPos(int pos) {
        this.yPos = pos;
        this.applyToDesigns();
    }

    public int getHighestPos() {
        int pos = this.getFilterType() == 0 ? this.getAxis().getChart().getAxisTopPos() : (this.getFilterType() == 1 ? this.getAxis().getUpperFilter().getYPos() : this.getAxis().getChart().getAxisTopPos());
        return pos - 1;
    }

    public int getLowestPos() {
        int pos = this.getFilterType() == 0 ? this.getAxis().getLowerFilter().getYPos() : (this.getFilterType() == 1 ? this.getAxis().getChart().getAxisTopPos() + this.getAxis().getHeight() : this.getAxis().getChart().getAxisTopPos() + this.getAxis().getHeight());
        return pos + 1;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public void applyToDesigns() {
        block25: {
            double value;
            Parameter param;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block24: {
                                        param = this.axis.getParameter();
                                        value = this.getValue();
                                        if (this.filterType != 0 || !this.axis.isFilterInverted() || !this.axis.isAxisInverted()) break block24;
                                        int i = 0;
                                        while (i < this.dataSheet.getDesignCount()) {
                                            if (this.dataSheet.getDesign(i).getDoubleValue(param) > value) {
                                                this.dataSheet.getDesign(i).setActive(this, false);
                                            } else {
                                                this.dataSheet.getDesign(i).setActive(this, true);
                                            }
                                            ++i;
                                        }
                                        break block25;
                                    }
                                    if (this.filterType != 1 || !this.axis.isFilterInverted() || !this.axis.isAxisInverted()) break block26;
                                    int i = 0;
                                    while (i < this.dataSheet.getDesignCount()) {
                                        if (this.dataSheet.getDesign(i).getDoubleValue(param) < value) {
                                            this.dataSheet.getDesign(i).setActive(this, false);
                                        } else {
                                            this.dataSheet.getDesign(i).setActive(this, true);
                                        }
                                        ++i;
                                    }
                                    break block25;
                                }
                                if (this.filterType != 0 || !this.axis.isAxisInverted()) break block27;
                                int i = 0;
                                while (i < this.dataSheet.getDesignCount()) {
                                    if (this.dataSheet.getDesign(i).getDoubleValue(param) < value) {
                                        this.dataSheet.getDesign(i).setActive(this, false);
                                    } else {
                                        this.dataSheet.getDesign(i).setActive(this, true);
                                    }
                                    ++i;
                                }
                                break block25;
                            }
                            if (this.filterType != 1 || !this.axis.isAxisInverted()) break block28;
                            int i = 0;
                            while (i < this.dataSheet.getDesignCount()) {
                                if (this.dataSheet.getDesign(i).getDoubleValue(param) > value) {
                                    this.dataSheet.getDesign(i).setActive(this, false);
                                } else {
                                    this.dataSheet.getDesign(i).setActive(this, true);
                                }
                                ++i;
                            }
                            break block25;
                        }
                        if (this.filterType != 0 || !this.axis.isFilterInverted()) break block29;
                        int i = 0;
                        while (i < this.dataSheet.getDesignCount()) {
                            if (this.dataSheet.getDesign(i).getDoubleValue(param) < value) {
                                this.dataSheet.getDesign(i).setActive(this, false);
                            } else {
                                this.dataSheet.getDesign(i).setActive(this, true);
                            }
                            ++i;
                        }
                        break block25;
                    }
                    if (this.filterType != 1 || !this.axis.isFilterInverted()) break block30;
                    int i = 0;
                    while (i < this.dataSheet.getDesignCount()) {
                        if (this.dataSheet.getDesign(i).getDoubleValue(param) > value) {
                            this.dataSheet.getDesign(i).setActive(this, false);
                        } else {
                            this.dataSheet.getDesign(i).setActive(this, true);
                        }
                        ++i;
                    }
                    break block25;
                }
                if (this.filterType != 0) break block31;
                int i = 0;
                while (i < this.dataSheet.getDesignCount()) {
                    if (this.dataSheet.getDesign(i).getDoubleValue(param) > value) {
                        this.dataSheet.getDesign(i).setActive(this, false);
                    } else {
                        this.dataSheet.getDesign(i).setActive(this, true);
                    }
                    ++i;
                }
                break block25;
            }
            if (this.filterType != 1) break block25;
            int i = 0;
            while (i < this.dataSheet.getDesignCount()) {
                if (this.dataSheet.getDesign(i).getDoubleValue(param) < value) {
                    this.dataSheet.getDesign(i).setActive(this, false);
                } else {
                    this.dataSheet.getDesign(i).setActive(this, true);
                }
                ++i;
            }
        }
    }

    private void log(String message) {
    }
}

