/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import data.DataSheet;
import exceptions.InconsistentDataException;
import gui.dialogs.ClusterDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import xdat.Main;

public class MainDataMenuActionListener
implements ActionListener {
    private Main mainWindow;
    static final boolean printLog = false;

    public MainDataMenuActionListener(Main mainWindow) {
        this.log("constructor called.");
        this.mainWindow = mainWindow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Import Data with Headers")) {
            if (this.mainWindow.getChartFrameCount() == 0 || JOptionPane.showConfirmDialog(this.mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", 2) == 0) {
                int returnVal;
                this.mainWindow.disposeAllChartFrames();
                JFileChooser chooser = new JFileChooser();
                if (Main.getUserPreferences().getCurrentDir() != null) {
                    chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
                }
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    String filepath = chooser.getSelectedFile().getAbsolutePath();
                    Main.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                    try {
                        this.mainWindow.setDataSheet(new DataSheet(filepath, true));
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e1.getMessage(), "Import Data", 0);
                    }
                    this.mainWindow.updateDataPanel();
                    this.mainWindow.getMainMenuBar().setItemsRequiringDataSheetEnabled(true);
                }
            }
        } else if (e.getActionCommand().equals("Import Data without Headers")) {
            if (this.mainWindow.getChartFrameCount() == 0 || JOptionPane.showConfirmDialog(this.mainWindow, "This operation will close all charts.\n Are you sure you want to continue?", "Import Data", 2) == 0) {
                int returnVal;
                this.mainWindow.disposeAllChartFrames();
                JFileChooser chooser = new JFileChooser();
                if (Main.getUserPreferences().getCurrentDir() != null) {
                    chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
                }
                if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                    String filepath = chooser.getSelectedFile().getAbsolutePath();
                    Main.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                    try {
                        this.mainWindow.setDataSheet(new DataSheet(filepath, false));
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e1.getMessage(), "Import Data", 0);
                    }
                    this.mainWindow.updateDataPanel();
                }
            }
        } else if (e.getActionCommand().equals("Update Data from File with Headers")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            if (Main.getUserPreferences().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                Main.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                try {
                    this.mainWindow.getDataSheet().updateData(filepath, true);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e1.getMessage(), "Import Data", 0);
                }
                catch (InconsistentDataException e1) {
                    JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(e1.getMessage()) + "\nThe previous state will be restored.", "Update Data", 0);
                }
                this.mainWindow.updateDataPanel();
                this.mainWindow.updateAllChartFrames();
            }
        } else if (e.getActionCommand().equals("Update Data from File without Headers")) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            if (Main.getUserPreferences().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                Main.getUserPreferences().setLastFile(chooser.getSelectedFile().getAbsolutePath());
                try {
                    this.mainWindow.getDataSheet().updateData(filepath, false);
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(this.mainWindow, "Error on importing data from file:\n " + e1.getMessage(), "Import Data", 0);
                }
                catch (InconsistentDataException e1) {
                    JOptionPane.showMessageDialog(this.mainWindow, String.valueOf(e1.getMessage()) + "\nThe previous state will be restored.", "Update Data", 0);
                }
                this.mainWindow.updateDataPanel();
                this.mainWindow.updateAllChartFrames();
            }
        } else if (e.getActionCommand().equals("Clustering")) {
            if (this.mainWindow.getDataSheet() == null) {
                JOptionPane.showMessageDialog(this.mainWindow, "Please create a data sheet first by selecting Data->Import.", "Clustering", 1);
            } else {
                new ClusterDialog(this.mainWindow, this.mainWindow, this.mainWindow.getDataSheet());
            }
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

