/*
 * Decompiled with CFR 0.152.
 */
package actionListeners;

import gui.dialogs.FileImportSettingsDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonModel;
import javax.swing.JFileChooser;
import xdat.Main;

public class FileImportSettingsDialogActionListener
implements ActionListener {
    static final boolean printLog = false;
    Main mainWindow;
    private FileImportSettingsDialog dialog;

    public FileImportSettingsDialogActionListener(Main mainWindow, FileImportSettingsDialog dialog) {
        this.log("constructor called.");
        this.mainWindow = mainWindow;
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == "...") {
            JFileChooser chooser = new JFileChooser();
            if (Main.getUserPreferences().getCurrentDir() != null) {
                chooser.setCurrentDirectory(new File(Main.getUserPreferences().getCurrentDir()));
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                String filepath = chooser.getSelectedFile().getAbsolutePath();
                this.dialog.getUseThisTextField().setText(filepath);
            }
        } else if (actionCommand == "Ok") {
            ButtonModel fileBrowsingSelectedModel = this.dialog.getFileBrowsingButtonGroup().getSelection();
            if (fileBrowsingSelectedModel.equals(this.dialog.getUseHomeRadioButton().getModel())) {
                Main.getUserPreferences().setDirToImportFrom(0);
            } else if (fileBrowsingSelectedModel.equals(this.dialog.getUseLastRadioButton().getModel())) {
                Main.getUserPreferences().setDirToImportFrom(1);
            } else if (fileBrowsingSelectedModel.equals(this.dialog.getUseThisRadioButton().getModel())) {
                Main.getUserPreferences().setDirToImportFrom(2);
            }
            Main.getUserPreferences().setUserDir(this.dialog.getUseThisTextField().getText());
            ButtonModel delimiterSelectedModel = this.dialog.getDelimiterButtonGroup().getSelection();
            if (delimiterSelectedModel.equals(this.dialog.getSpaceRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter(" ");
            } else if (delimiterSelectedModel.equals(this.dialog.getTabRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter("\\t");
            } else if (delimiterSelectedModel.equals(this.dialog.getAllBlanksRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter("\\s");
            } else if (delimiterSelectedModel.equals(this.dialog.getCommaRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter(",");
            } else if (delimiterSelectedModel.equals(this.dialog.getSemiColonRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter(";");
            } else if (delimiterSelectedModel.equals(this.dialog.getOtherRadioButton().getModel())) {
                Main.getUserPreferences().setDelimiter(this.dialog.getOtherTextField().getText());
                Main.getUserPreferences().setOtherDelimiter(this.dialog.getOtherTextField().getText());
            }
            Main.getUserPreferences().setTreatConsecutiveAsOne(this.dialog.getTreatConsecutiveAsOneCheckBox().isSelected());
            this.dialog.dispose();
        } else if (actionCommand == "Cancel") {
            this.dialog.dispose();
        } else {
            System.out.println(e.getActionCommand());
        }
    }

    private void log(String message) {
    }
}

