/*
 *  Copyright 2010, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */


package gui.menus;

import gui.frames.ChartFrame;
import chart.*;
import javax.swing.*;
import main.Main;
import actionListeners.ChartFrameSelectParametersMenuActionListener;
import java.awt.event.*;
import java.awt.*;

/**
 * Menu of the {@link gui.frames.ChartFrame} that allows to select the {@link data.Parameter}s to be displayed.
 */
public class ChartFrameSelectParametersMenu 
extends JMenu
{
	
	/** The version tracking unique identifier for Serialization. */
	static final long serialVersionUID = 0001;
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/** The actionlistener. */
	private ChartFrameSelectParametersMenuActionListener cmd;
	
	/** Array containing all check box menu items. */
	private JCheckBoxMenuItem[] checkBoxMenuItems;
	
	/**
	 * Instantiates a new chart frame select parameters menu.
	 *
	 * @param mainWindow the main window
	 * @param chartFrame the chart frame
	 * @param chart the chart
	 */
	public ChartFrameSelectParametersMenu(Main mainWindow, ChartFrame chartFrame, Chart chart)
	{
		super("Parameters");
		log("constructor invoked.");
		chartFrame.setSelectParametersMenu(this);
		this.setMnemonic(KeyEvent.VK_P);

		this.cmd = new ChartFrameSelectParametersMenuActionListener(mainWindow, chartFrame);
		
		JMenuItem mi;
		// select all
		mi = new JMenuItem("Select All");
		mi.setMnemonic(KeyEvent.VK_S);
		mi.addActionListener(cmd);
		this.add(mi);
		
		// unselect all
		mi = new JMenuItem("Unselect All");
		mi.setMnemonic(KeyEvent.VK_U);
		mi.addActionListener(cmd);
		this.add(mi);
		
		// reverse selection
		mi = new JMenuItem("Reverse Selection");
		mi.setMnemonic(KeyEvent.VK_R);
		mi.addActionListener(cmd);
		this.add(mi);	
		
		// selection dialog
		mi = new JMenuItem("Custom Selection");
		mi.setMnemonic(KeyEvent.VK_C);
		mi.addActionListener(cmd);
		this.add(mi);	
		
		//Separator
		this.addSeparator();
		checkBoxMenuItems = new JCheckBoxMenuItem[mainWindow.getDataSheet().getParameterCount()];
		for (int i = 0; i<checkBoxMenuItems.length; i++)
		{
			checkBoxMenuItems[i] = new JCheckBoxMenuItem(mainWindow.getDataSheet().getParameter(i).getName());
			checkBoxMenuItems[i].addActionListener(cmd);
//			menuItems.add(jcbmi);
			chart.getAxis(0);
			checkBoxMenuItems[i].setState(chart.getAxis(mainWindow.getDataSheet().getParameter(i).getName()).isActive());
			
			this.add(checkBoxMenuItems[i]);
		}
		

		
	}

	/**
	 * Sets the ctrl accelerator.
	 *
	 * @param mi the menu item
	 * @param acc the accelerator
	 */	
	private void setCtrlAccelerator(JMenuItem mi, char acc)
	{
		KeyStroke ks = KeyStroke.getKeyStroke(acc, Event.CTRL_MASK);
		mi.setAccelerator(ks);
	}
	
	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(ChartFrameSelectParametersMenu.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}

	/**
	 * Gets the check box menu items.
	 *
	 * @return the check box menu items
	 */
	public JCheckBoxMenuItem[] getCheckBoxMenuItems() {
		return checkBoxMenuItems;
	}		
}
