/*
 *  Copyright 2010, Enguerrand de Rochefort
 * 
 * This file is part of xdat.
 *
 * xdat is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * xdat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xdat.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package actionListeners;

import gui.dialogs.DisplaySettingsDialog;
import gui.panels.ChartDisplaySettingsPanel;

import java.awt.event.*;
import main.*;

/**
 * ActionListener for the Ok button of a {@link ChartDisplaySettingsPanel} that was instantiated 
 * using the constructor form {@link ChartDisplaySettingsPanel#ChartDisplaySettingsPanel(Main, DisplaySettingsDialog)}.
 * <p>
 * When a ChartDisplaySettingsPanel is instantiated without a ChartFrame object as the last argument, the settings 
 * made in the panel are applied to the default settings in the {@link UserPreferences}.
 * In order to do this correctly when the Ok button is pressed, the button must use this dedicated ActionListener.
 * 
 * @see ChartSpecificDisplaySettingsDialogActionListener
 */
public class DefaultDisplaySettingsDialogActionListener 
implements ActionListener
{
	
	/** Flag to enable debug message printing for this class. */
	static final boolean printLog=false;
	
	/** The dialog. */
	private DisplaySettingsDialog dialog;
	
	/** The main window. */
	private Main mainWindow;

	/**
	 * Instantiates a new default display settings dialog action listener.
	 *
	 * @param mainWindow the main window
	 * @param dialog the dialog
	 */
	public DefaultDisplaySettingsDialogActionListener(Main mainWindow, DisplaySettingsDialog dialog)
	{
		this.mainWindow = mainWindow;
		this.dialog = dialog;
		log(" Constructor: Tic label color = "+this.mainWindow.getUserPreferences().getAxisTicLabelFontColor().toString());
		
	}
	
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		String actionCommand = e.getActionCommand();
		if(actionCommand == "Ok")
		{
			this.mainWindow.getUserPreferences().setAxisHeight((Integer)this.dialog.getChartDisplaySettingsPanel().getAxisHeightSpinner().getValue());
			this.mainWindow.getUserPreferences().setDefaultBackgroundColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getBackGroundColor());
			this.mainWindow.getUserPreferences().setActiveDesignDefaultColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getActiveDesignColor());
			this.mainWindow.getUserPreferences().setInActiveDesignDefaultColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getFilteredDesignColor());
			this.mainWindow.getUserPreferences().setFilterColor(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().getFilterColor());
			this.mainWindow.getUserPreferences().setShowDesignIDs(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().isShowDesignIDs());
			this.mainWindow.getUserPreferences().setShowFilteredDesigns(this.dialog.getChartDisplaySettingsPanel().getChartDisplaySettingsActionListener().isShowFilteredDesigns());
			this.mainWindow.getUserPreferences().setDesignLabelFontSize((Integer)this.dialog.getChartDisplaySettingsPanel().getDesignLabelFontSizeSpinner().getValue());
			this.mainWindow.getUserPreferences().setFilterWidth((Integer)this.dialog.getChartDisplaySettingsPanel().getFilterWidthSpinner().getValue());
			this.mainWindow.getUserPreferences().setFilterHeight((Integer)this.dialog.getChartDisplaySettingsPanel().getFilterHeightSpinner().getValue());
			
			this.mainWindow.getUserPreferences().setAxisColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getAxisColor());
			this.mainWindow.getUserPreferences().setAxisLabelFontColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getAxisLabelColor());
			this.mainWindow.getUserPreferences().setAxisTicLabelFontColor(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().getTicLabelColor());		
			this.mainWindow.getUserPreferences().setFilterInverted(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isInvertFilter() );
			this.mainWindow.getUserPreferences().setAxisInverted(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isInvertAxis() );
			this.mainWindow.getUserPreferences().setAutoFitAxis(this.dialog.getAxisDisplaySettingsPanel().getAxisDisplaySettingsActionListener().isAutoFitAxis() );
			this.mainWindow.getUserPreferences().setAxisDefaultMin(this.dialog.getAxisDisplaySettingsPanel().getAxisMin());
			this.mainWindow.getUserPreferences().setAxisDefaultMax(this.dialog.getAxisDisplaySettingsPanel().getAxisMax());
			
			this.mainWindow.getUserPreferences().setAxisWidth((Integer)this.dialog.getAxisDisplaySettingsPanel().getAxisWidthSpinner().getValue());
			this.mainWindow.getUserPreferences().setAxisLabelFontSize((Integer)this.dialog.getAxisDisplaySettingsPanel().getAxisLabelFontSizeSpinner().getValue());
			this.mainWindow.getUserPreferences().setAxisTicLength((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicSizeSpinner().getValue());
			this.mainWindow.getUserPreferences().setAxisTicCount((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicCountSpinner().getValue());
			this.mainWindow.getUserPreferences().setAxisTicLabelFontSize((Integer)this.dialog.getAxisDisplaySettingsPanel().getTicLabelFontSizeSpinner().getValue());
			log(" OK: Tic label color = "+this.mainWindow.getUserPreferences().getAxisTicLabelFontColor().toString());
			this.dialog.dispose();
		}
		else if(actionCommand == "Cancel")
		{
			this.dialog.dispose();
		}
		else if(actionCommand == "Yes" || actionCommand == "No" )
		{
			// Do nothing
		}
		else
		{
			System.out.println("ChartDisplaySettingsActionListener: "+e.getActionCommand());
		}
	}

	/**
	 * Prints debug information to stdout when printLog is set to true.
	 *
	 * @param message the message
	 */
	private void log(String message)
	{
		if(DefaultDisplaySettingsDialogActionListener.printLog && Main.isLoggingEnabled())
		{
			System.out.println(this.getClass().getName()+"."+message);
		}
	}	
}
